/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.SWCalibrationCommandPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SWCalibrationCommandPacketTest
extends TestCase {
    int timeSecs;
    int instrumentID;
    byte channelBits;
    byte subtype;
    byte ctrlLines;
    byte attenuation;
    float amplitude;
    byte amplitudeUnit;
    float dcOffset;
    float duration;
    float tOn;
    float ramp;
    String identifier;
    float frequency;
    SWCalibrationCommandPacket packet;
    static /* synthetic */ Class class$0;

    public SWCalibrationCommandPacketTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.SWCalibrationCommandPacketTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
        this.timeSecs = 10;
        this.instrumentID = 5;
        this.channelBits = 1;
        this.subtype = (byte)2;
        this.amplitudeUnit = (byte)3;
        this.ctrlLines = (byte)4;
        this.attenuation = 1;
        this.amplitude = 2.0f;
        this.dcOffset = 1.0f;
        this.duration = 30.3f;
        this.tOn = 12.0f;
        this.ramp = 12.3f;
        this.identifier = "test";
        this.frequency = 2.3f;
        this.packet = new SWCalibrationCommandPacket(this.timeSecs, this.instrumentID, this.channelBits, this.ctrlLines, this.attenuation, this.amplitudeUnit, this.amplitude, this.dcOffset, this.tOn, this.ramp, this.duration, this.identifier, this.frequency);
    }

    public void testConstructor() throws Exception {
        Assert.assertNotNull((String)"null regular constructor", (Object)this.packet);
    }

    public void testGets() throws Exception {
        Assert.assertEquals((String)"getFrequency()", (double)this.frequency, (double)this.packet.getFrequency(), (double)0.001);
    }

    public void testSets() throws Exception {
        this.frequency = 0.4f;
        this.packet.setFrequency(this.frequency);
        Assert.assertEquals((String)"setFrequency()", (double)this.frequency, (double)this.packet.getFrequency(), (double)0.001);
    }

    public void testPackable() throws Exception {
        byte[] buffer = new byte[this.packet.getDataLength() + 2];
        this.packet.writeTo(buffer, 2);
        SWCalibrationCommandPacket packedPacket = new SWCalibrationCommandPacket(buffer, 2, buffer.length);
        Assert.assertEquals((String)"getFrequency()", (double)this.frequency, (double)packedPacket.getFrequency(), (double)0.001);
    }
}

