/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.FileLog;
import ca.nanometrics.util.LogConfig;
import ca.nanometrics.util.NmxDateFormat;
import java.io.IOException;
import java.util.Date;

public class AppLog
extends FileLog {
    public static final String DEFAULT_EXTENSION = "log";
    private String directory;
    private String baseName;
    private String extension;
    private NmxDateFormat dateFormatter = new NmxDateFormat("_yyyyMMdd");
    private long logDate = 0L;

    public AppLog(String logpath, String logfile, int verbosity) throws IOException {
        this.directory = logpath;
        this.baseName = logfile;
        this.extension = "";
        int lastDot = logfile.lastIndexOf(46);
        if (lastDot >= 0) {
            this.baseName = logfile.substring(0, lastDot);
            this.extension = logfile.substring(lastDot + 1);
        }
        if (this.extension.length() < 1) {
            this.extension = DEFAULT_EXTENSION;
        }
        long now = System.currentTimeMillis();
        this.logDate = now / 1000L / 86400L;
        String filename = this.buildLogName(now);
        this.init(this.directory, filename);
        this.setVerbosity(verbosity);
    }

    public AppLog(String logpath, String logfile) throws IOException {
        this(logpath, logfile, 2);
    }

    public AppLog(String logfile, int verbosity) throws IOException {
        this(".", logfile, verbosity);
    }

    public AppLog(String logfile) throws IOException {
        this(".", logfile, 2);
    }

    public AppLog(LogConfig config) throws IOException {
        this(config.getLogDirectory(), config.getLogFilename(), config.getVerbosity());
    }

    public String buildLogName(long timeMillis) {
        String filename = String.valueOf(this.baseName) + this.dateFormatter.format(new Date(timeMillis)) + "." + this.extension;
        return filename;
    }

    public boolean reopenOnNewDate() {
        long now = System.currentTimeMillis();
        long currentDate = now / 1000L / 86400L;
        if (currentDate != this.logDate) {
            this.logDate = currentDate;
            String filename = this.buildLogName(now);
            try {
                this.reopen(this.directory, filename, false);
                this.report(this, 1, 3, "New log file: " + filename);
                return true;
            }
            catch (IOException ioe) {
                this.report(this, 2, 3, "Cannot open log file: " + filename);
            }
        }
        return false;
    }
}

