/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.BigEndian;
import java.io.ByteArrayOutputStream;

public class Base64 {
    public static final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final char pad = '=';

    public static String encodeInts(int[] intArray) {
        int numBytes = intArray.length * 4;
        byte[] bytes = new byte[numBytes];
        int intIndex = 0;
        while (intIndex < intArray.length) {
            BigEndian.writeInt(bytes, intIndex * 4, intArray[intIndex]);
            ++intIndex;
        }
        String encodedString = Base64.encode(bytes);
        return encodedString;
    }

    public static String encode(byte[] rawBytes) {
        StringBuffer outputChars = new StringBuffer();
        int numOutputChars = 0;
        int codeIndex = 2;
        while (codeIndex < rawBytes.length) {
            int threeBytes = (rawBytes[codeIndex - 2] & 0xFF) << 24 | (rawBytes[codeIndex - 1] & 0xFF) << 16 | (rawBytes[codeIndex] & 0xFF) << 8;
            int outi = 0;
            while (outi < 4) {
                outputChars.append(Base64.getCharacterFromValue((byte)(threeBytes >> 26 & 0x3F)));
                threeBytes <<= 6;
                ++numOutputChars;
                ++outi;
            }
            if (numOutputChars % 72 == 0) {
                outputChars.append("\n");
            }
            codeIndex += 3;
        }
        int numLeftToEncode = rawBytes.length % 3;
        if (numLeftToEncode == 1) {
            int oneByte = (rawBytes[rawBytes.length - 1] & 0xFF) << 24;
            outputChars.append(Base64.getCharacterFromValue((byte)(oneByte >> 26 & 0x3F)));
            outputChars.append(Base64.getCharacterFromValue((byte)((oneByte <<= 6) >> 26 & 0x3F)));
            outputChars.append(Base64.getPadCharacter());
            outputChars.append(Base64.getPadCharacter());
        } else if (numLeftToEncode == 2) {
            int twoBytes = (rawBytes[rawBytes.length - 2] & 0xFF) << 24 | (rawBytes[rawBytes.length - 1] & 0xFF) << 16;
            outputChars.append(Base64.getCharacterFromValue((byte)(twoBytes >> 26 & 0x3F)));
            outputChars.append(Base64.getCharacterFromValue((byte)((twoBytes <<= 6) >> 26 & 0x3F)));
            outputChars.append(Base64.getCharacterFromValue((byte)((twoBytes <<= 6) >> 26 & 0x3F)));
            outputChars.append(Base64.getPadCharacter());
        }
        return outputChars.toString();
    }

    public static int[] decodeInts(String dataString) {
        char[] dataStringChars = dataString.toCharArray();
        byte[] bytes = Base64.decode(dataStringChars);
        int numInts = bytes.length / 4;
        int[] intArray = new int[numInts];
        int intIndex = 0;
        while (intIndex < numInts) {
            intArray[intIndex] = BigEndian.readInt(bytes, intIndex * 4);
            ++intIndex;
        }
        return intArray;
    }

    public static byte[] decode(String dataString) {
        char[] dataStringChars = dataString.toCharArray();
        byte[] bytes = Base64.decode(dataStringChars);
        return bytes;
    }

    public static byte[] decode(char[] dataChars) {
        ByteArrayOutputStream outputByteStream = new ByteArrayOutputStream();
        int threeBytes = 0;
        int byteIndex = 0;
        byte value = 0;
        int charIndex = 0;
        while (charIndex < dataChars.length) {
            if (Base64.isPadCharacter(dataChars[charIndex])) {
                threeBytes <<= 6 * (4 - byteIndex % 4);
                if (byteIndex % 4 == 0) break;
                Base64.writeBytes(threeBytes, byteIndex % 4 - 1, outputByteStream);
                break;
            }
            value = Base64.getValueFromCharacter(dataChars[charIndex]);
            if (value != -1) {
                threeBytes = threeBytes << 6 | value;
                if (++byteIndex % 4 == 0) {
                    Base64.writeBytes(threeBytes, 3, outputByteStream);
                }
            }
            ++charIndex;
        }
        return outputByteStream.toByteArray();
    }

    public static char getCharacterFromValue(byte charIndex) {
        if (charIndex > alphabet.length) {
            return '\u0000';
        }
        return alphabet[charIndex];
    }

    public static byte getValueFromCharacter(char alphabetChar) {
        int ai = 0;
        while (ai < alphabet.length) {
            if (alphabet[ai] == alphabetChar) {
                return (byte)ai;
            }
            ++ai;
        }
        return -1;
    }

    public static char getPadCharacter() {
        return '=';
    }

    public static boolean isPadCharacter(char padTestChar) {
        return padTestChar == '=';
    }

    private static void writeBytes(int byteInt, int numToWrite, ByteArrayOutputStream baos) {
        byte[] writeBytes = new byte[]{(byte)(byteInt >> 16 & 0xFF), (byte)(byteInt >> 8 & 0xFF), (byte)(byteInt & 0xFF)};
        baos.write(writeBytes, 0, numToWrite);
    }
}

