/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Float16;

public class BigEndian {
    public static int readInt(byte[] buffer, int index) {
        int value = (buffer[index + 0] & 0xFF) << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
        return value;
    }

    public static long readUInt(byte[] buffer, int index) {
        return (long)BigEndian.readInt(buffer, index) & 0xFFFFFFFFL;
    }

    public static void writeInt(byte[] buffer, int index, int value) {
        buffer[index + 0] = (byte)(value >> 24 & 0xFF);
        buffer[index + 1] = (byte)(value >> 16 & 0xFF);
        buffer[index + 2] = (byte)(value >> 8 & 0xFF);
        buffer[index + 3] = (byte)(value & 0xFF);
    }

    public static short readShort(byte[] buffer, int index) {
        int value = (buffer[index + 0] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
        return (short)value;
    }

    public static int readUShort(byte[] buffer, int index) {
        return BigEndian.readShort(buffer, index) & 0xFFFF;
    }

    public static void writeShort(byte[] buffer, int index, short value) {
        buffer[index + 0] = (byte)(value >> 8 & 0xFF);
        buffer[index + 1] = (byte)(value & 0xFF);
    }

    public static long readLong(byte[] buffer, int index) {
        long value = (long)(buffer[index + 0] & 0xFF) << 56 | (long)(buffer[index + 1] & 0xFF) << 48 | (long)(buffer[index + 2] & 0xFF) << 40 | (long)(buffer[index + 3] & 0xFF) << 32 | (long)(buffer[index + 4] & 0xFF) << 24 | (long)(buffer[index + 5] & 0xFF) << 16 | (long)(buffer[index + 6] & 0xFF) << 8 | (long)(buffer[index + 7] & 0xFF);
        return value;
    }

    public static void writeLong(byte[] buffer, int index, long value) {
        buffer[index + 0] = (byte)(value >> 56 & 0xFFL);
        buffer[index + 1] = (byte)(value >> 48 & 0xFFL);
        buffer[index + 2] = (byte)(value >> 40 & 0xFFL);
        buffer[index + 3] = (byte)(value >> 32 & 0xFFL);
        buffer[index + 4] = (byte)(value >> 24 & 0xFFL);
        buffer[index + 5] = (byte)(value >> 16 & 0xFFL);
        buffer[index + 6] = (byte)(value >> 8 & 0xFFL);
        buffer[index + 7] = (byte)(value & 0xFFL);
    }

    public static int readInt24(byte[] buffer, int index) {
        int value = buffer[index + 0] << 16 | (buffer[index + 1] & 0xFF) << 8 | buffer[index + 2] & 0xFF;
        return value;
    }

    public static int readUInt24(byte[] buffer, int index) {
        return BigEndian.readInt24(buffer, index) & 0xFFFFFF;
    }

    public static void writeInt24(byte[] buffer, int index, int value) {
        buffer[index + 0] = (byte)(value >> 16 & 0xFF);
        buffer[index + 1] = (byte)(value >> 8 & 0xFF);
        buffer[index + 2] = (byte)(value & 0xFF);
    }

    public static float readFloat(byte[] buffer, int index) {
        int bits = BigEndian.readInt(buffer, index);
        return Float.intBitsToFloat(bits);
    }

    public static void writeFloat(byte[] buffer, int index, float num) {
        int bits = Float.floatToIntBits(num);
        BigEndian.writeInt(buffer, index, bits);
    }

    public static double readDouble(byte[] buffer, int index) {
        long bits = BigEndian.readLong(buffer, index);
        return Double.longBitsToDouble(bits);
    }

    public static void writeDouble(byte[] buffer, int index, double num) {
        long bits = Double.doubleToLongBits(num);
        BigEndian.writeLong(buffer, index, bits);
    }

    public static double readFloat16(byte[] buffer, int index) {
        return Float16.bitsToFloat(BigEndian.readUShort(buffer, index));
    }

    public static String readString(byte[] buffer, int index, int fieldLen) {
        int len = 0;
        len = 0;
        while (len < fieldLen) {
            if (buffer[index + len] == 0) break;
            ++len;
        }
        if (len > 0) {
            return new String(buffer, index, len);
        }
        return new String();
    }

    public static void writeString(byte[] buffer, int index, String str, int len) {
        byte[] data = str.getBytes();
        int bytesToCopy = Math.min(data.length, len - 1);
        if (bytesToCopy > 0) {
            System.arraycopy(data, 0, buffer, index, bytesToCopy);
        }
        buffer[index + bytesToCopy] = 0;
    }
}

