/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.EndianWriter;

public class BigEndianWriter
implements EndianWriter {
    private byte[] buffer;
    private int offset;

    public BigEndianWriter(byte[] aBuffer, int anOffset) {
        this.buffer = aBuffer;
        this.offset = anOffset;
    }

    public BigEndianWriter(byte[] aBuffer) {
        this(aBuffer, 0);
    }

    public void setOffset(int newOffset) {
        this.offset = newOffset;
    }

    public void write(byte[] barray, int start, int bytesToWrite) {
        System.arraycopy(barray, start, this.buffer, this.offset, bytesToWrite);
        this.offset += bytesToWrite;
    }

    public void write(byte[] barray) {
        this.write(barray, 0, barray.length);
    }

    public void writeInt(int value) {
        BigEndian.writeInt(this.buffer, this.offset, value);
        this.offset += 4;
    }

    public void writeByte(byte value) {
        this.buffer[this.offset] = value;
        ++this.offset;
    }

    public void writeShort(short value) {
        BigEndian.writeShort(this.buffer, this.offset, value);
        this.offset += 2;
    }

    public void writeLong(long value) {
        BigEndian.writeLong(this.buffer, this.offset, value);
        this.offset += 8;
    }

    public void writeInt24(int value) {
        BigEndian.writeInt24(this.buffer, this.offset, value);
        this.offset += 3;
    }

    public void writeFloat(float value) {
        BigEndian.writeFloat(this.buffer, this.offset, value);
        this.offset += 4;
    }

    public void writeDouble(double value) {
        BigEndian.writeDouble(this.buffer, this.offset, value);
        this.offset += 8;
    }

    public void writeString(String str, int len) {
        BigEndian.writeString(this.buffer, this.offset, str, len);
        this.offset += len;
    }
}

