/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

public class BinarySearchTreeNode {
    private BinarySearchTreeNode m_left = null;
    private BinarySearchTreeNode m_right = null;
    private BinarySearchTreeNode m_parent = null;
    private Comparable m_key = null;

    public BinarySearchTreeNode(Comparable key, BinarySearchTreeNode parent) {
        this.setKey(key);
        this.setParent(parent);
    }

    public int compareKey(Comparable key) {
        return -key.compareTo(this.getKey());
    }

    public int compareKey(BinarySearchTreeNode node) {
        return -this.getKey().compareTo(node.getKey());
    }

    public void dispose() {
        this.setParent(null);
        this.setKey(null);
        if (this.getLeft() != null) {
            this.getLeft().dispose();
        }
        if (this.getRight() != null) {
            this.getRight().dispose();
        }
    }

    public Comparable getKey() {
        return this.m_key;
    }

    public BinarySearchTreeNode getLeft() {
        return this.m_left;
    }

    public BinarySearchTreeNode getMin() {
        BinarySearchTreeNode curNode = this;
        while (curNode.getLeft() != null) {
            curNode = curNode.getLeft();
        }
        return curNode;
    }

    public BinarySearchTreeNode getMax() {
        BinarySearchTreeNode curNode = this;
        while (curNode.getRight() != null) {
            curNode = curNode.getRight();
        }
        return curNode;
    }

    public BinarySearchTreeNode getNext() {
        if (this.getRight() != null) {
            return this.getRight().getMin();
        }
        BinarySearchTreeNode curNode = this.getParent();
        while (curNode != null && curNode.compareKey(this.m_key) < 0) {
            curNode = curNode.getParent();
        }
        return curNode;
    }

    public BinarySearchTreeNode getParent() {
        return this.m_parent;
    }

    public BinarySearchTreeNode getPrevious() {
        if (this.getLeft() != null) {
            return this.getLeft().getMax();
        }
        BinarySearchTreeNode curNode = this.getParent();
        while (curNode != null && curNode.compareKey(this.m_key) > 0) {
            curNode = curNode.getParent();
        }
        return curNode;
    }

    public BinarySearchTreeNode getRight() {
        return this.m_right;
    }

    public boolean isLeaf() {
        return this.getLeft() == null && this.getRight() == null;
    }

    public void setKey(Comparable key) {
        this.m_key = key;
    }

    public void setLeft(BinarySearchTreeNode left) {
        this.m_left = left;
        if (this.m_left != null && this.m_left.getParent() != this) {
            this.m_left.setParent(this);
        }
    }

    public void setParent(BinarySearchTreeNode parent) {
        if (this.m_parent != null) {
            if (this.m_parent.getLeft() == this) {
                this.m_parent.setLeft(null);
            } else if (this.m_parent.getRight() == this) {
                this.m_parent.setRight(null);
            }
        }
        this.m_parent = parent;
        if (this.m_parent != null) {
            if (this.m_parent.compareKey(this.m_key) > 0) {
                if (this.m_parent.getLeft() == null) {
                    this.m_parent.setLeft(this);
                }
            } else if (this.m_parent.getRight() == null) {
                this.m_parent.setRight(this);
            }
        }
    }

    public void setRight(BinarySearchTreeNode right) {
        this.m_right = right;
        if (this.m_right != null && this.m_right.getParent() != this) {
            this.m_right.setParent(this);
        }
    }

    public void swapKeys(BinarySearchTreeNode node) {
        Comparable temp = this.getKey();
        this.setKey(node.getKey());
        node.setKey(temp);
    }
}

