/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Log;
import ca.nanometrics.util.QueueImpl;
import ca.nanometrics.util.Runner;

public abstract class BufferedConsumer
extends Runner {
    private static final int TICK_INTERVAL = 1000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int HOURS_PER_DAY = 24;
    private static final int READ_TIMEOUT = 200;
    private static final int WDG_LOOP_TIMEOUT = 60;
    protected QueueImpl objQ = new QueueImpl();
    private int maxQueue = 0;
    private int minQueue = 0;
    private int discardCount = 0;
    private boolean queueFull = false;

    public BufferedConsumer(String name) {
        super(name);
    }

    public BufferedConsumer(String name, int queueLength) {
        super(name);
        this.maxQueue = queueLength;
        this.minQueue = 8 * this.maxQueue / 10;
    }

    protected void append(Object obj) {
        if (this.maxQueue == 0 || this.objQ.size() < this.maxQueue) {
            this.objQ.put(obj);
        } else {
            if (!this.queueFull) {
                Log.report(this, 2, 3, "Queue full, data being discarded");
                this.queueFull = true;
                this.discardCount = 0;
            }
            ++this.discardCount;
        }
    }

    protected int getQsize() {
        return this.objQ.size();
    }

    protected abstract void process(Object var1);

    protected void open() {
    }

    protected void close() {
    }

    protected void tick() {
    }

    protected void onNewHour() {
    }

    protected void onNewDay() {
    }

    public final void run() {
        this.setWdgTimeout(60);
        this.open();
        long millis = System.currentTimeMillis();
        long lastTick = millis / 1000L;
        int lastHour = (int)(millis / 3600000L);
        int lastDay = lastHour / 24;
        while (this.stayAlive) {
            int thisDay;
            long thisTick;
            this.setWdgTimeout(60);
            try {
                Object obj = this.objQ.get(200);
                if (obj != null) {
                    this.process(obj);
                }
            }
            catch (InterruptedException obj) {
            }
            catch (Exception e) {
                Log.report(this, 4, 4, "Exception in process(): " + e);
            }
            if (this.queueFull && this.objQ.size() < this.minQueue) {
                this.queueFull = false;
                Log.report(this, 3, 3, "Discarded " + this.discardCount + " packets since Queue full");
            }
            if ((thisTick = (millis = System.currentTimeMillis()) / 1000L) == lastTick) continue;
            lastTick = thisTick;
            try {
                this.tick();
            }
            catch (Exception e) {
                Log.report(this, 4, 4, "Exception in tick(): " + e);
            }
            int thisHour = (int)(millis / 3600000L);
            if (thisHour != lastHour) {
                lastHour = thisHour;
                try {
                    this.onNewHour();
                }
                catch (Exception e) {
                    Log.report(this, 4, 4, "Exception in onNewHour(): " + e);
                }
            }
            if ((thisDay = thisHour / 24) == lastDay) continue;
            lastDay = thisDay;
            try {
                this.onNewDay();
            }
            catch (Exception e) {
                Log.report(this, 4, 4, "Exception in onNewDay(): " + e);
            }
        }
        this.close();
    }
}

