/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.zip.CRC32;

public class ByteArrayHelper {
    private static final int BYTE_NOT_IN_ARRAY = -1;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteArrayHelper() {
    }

    public static byte[] createPaddedArray(int length, byte[] srcByteArray, byte padding) {
        byte[] returnArray = new byte[length];
        int sourceArrayLength = srcByteArray.length;
        int paddingLength = length - sourceArrayLength;
        Arrays.fill(returnArray, 0, paddingLength, padding);
        System.arraycopy(srcByteArray, 0, returnArray, paddingLength, sourceArrayLength);
        return returnArray;
    }

    public static long getCRC32(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return crc32.getValue();
    }

    public static String byteArrayToHexString(byte[] byteArray, boolean spaceBetween) {
        StringBuffer s = new StringBuffer();
        if (spaceBetween) {
            int i = 0;
            while (i < byteArray.length) {
                s = s.append(ByteArrayHelper.byteToHex(byteArray[i])).append(" ");
                ++i;
            }
        } else {
            int i = 0;
            while (i < byteArray.length) {
                s = s.append(ByteArrayHelper.byteToHex(byteArray[i]));
                ++i;
            }
        }
        return s.toString();
    }

    public static byte[] subByteArrayFromStartEnd(byte[] byteArray, int offsetStart, int offsetEnd) {
        int length = offsetEnd - offsetStart;
        byte[] subArray = new byte[length];
        System.arraycopy(byteArray, offsetStart, subArray, 0, length);
        return subArray;
    }

    public static byte[] subByteArray(byte[] byteArray, int offsetStart, int length) {
        byte[] subArray = new byte[length];
        System.arraycopy(byteArray, offsetStart, subArray, 0, length);
        return subArray;
    }

    public static char[] gethexDigitArray() {
        return hexDigit;
    }

    public static String byteToHex(byte b) {
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static byte[] hexToBytes(String hex) throws NumberFormatException {
        BigInteger bigInt;
        try {
            bigInt = new BigInteger(hex, 16);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Input Not Hex!");
        }
        byte[] bigIntBytes = bigInt.toByteArray();
        if (bigIntBytes[0] == 0) {
            bigIntBytes = ByteArrayHelper.subByteArrayFromStartEnd(bigIntBytes, 1, bigIntBytes.length);
        }
        return bigIntBytes;
    }

    public static int unPaddedLength(byte[] byteArray, byte padByte) {
        int length = 0;
        int index = 0;
        index = ByteArrayHelper.indexOf(byteArray, padByte);
        if (index == -1) {
            return byteArray.length;
        }
        int i = 0;
        while (i < index) {
            ++length;
            ++i;
        }
        return length;
    }

    public static int indexOf(byte[] byteArray, byte aByte) {
        int i = 0;
        while (i < byteArray.length) {
            if (byteArray[i] == aByte) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

