/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.DisplayInDispatcherThreadRunnable;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ErrorDisplay {
    private static int MAX_CHARS_PER_LINE = 100;

    public static void displayWarning(Throwable error) {
        ErrorDisplay.display(error.getMessage(), "Warning!");
    }

    public static void display(Throwable error) {
        ErrorDisplay.display(error.getMessage(), error.getClass().getName());
    }

    public static void display(String error, String title) {
        if (EventQueue.isDispatchThread()) {
            error = ErrorDisplay.enforceMaximumCharsOnString(error, MAX_CHARS_PER_LINE);
            JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), error, title, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(new DisplayInDispatcherThreadRunnable(error, title));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String enforceMaximumCharsOnString(String title, int maximum) {
        if (title == null) {
            return "";
        }
        StringBuffer newTitle = new StringBuffer(title);
        int lineLength = 0;
        int index = 0;
        while (index < newTitle.length()) {
            if (newTitle.charAt(index) == '\n') {
                lineLength = 0;
            } else if (++lineLength > maximum) {
                int spaceIndex = index;
                while (spaceIndex > 0 && lineLength > 0) {
                    if (newTitle.charAt(spaceIndex) == ' ') break;
                    --spaceIndex;
                    --lineLength;
                }
                if (lineLength <= 0) {
                    spaceIndex = index;
                }
                if (++spaceIndex < newTitle.length()) {
                    newTitle.insert(spaceIndex, '\n');
                }
                lineLength = 0;
            }
            ++index;
        }
        return newTitle.toString();
    }
}

