/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

public class Float16Imp {
    static final int F32_SIGN_BITS = 1;
    static final int F32_EXPONENT_BITS = 8;
    static final int F32_MANTISSA_BITS = 23;
    static final int F32_SIGN_MASK = 1;
    static final int F32_EXPONENT_MASK = 255;
    static final int F32_MANTISSA_MASK = 0x7FFFFF;
    static final int F32_SIGN_SHIFT = 31;
    static final int F32_EXPONENT_SHIFT = 23;
    static final int F32_MANTISSA_SHIFT = 0;
    static final int F32_EXPONENT_BASE = 127;
    static final int F32_MANTISSA_BASE = 0x800000;
    static final int INTEGER_BITS = 32;
    static final int F16_SIGN_BITS = 1;
    static final int F16_EXPONENT_BITS = 6;
    static final int F16_MANTISSA_BITS = 9;
    static final int F16_MAGNITUDE_BITS = 15;
    static final int F16_SIGN_MASK = 1;
    static final int F16_EXPONENT_MASK = 63;
    static final int F16_MANTISSA_MASK = 511;
    static final int F16_MAGNITUDE_MASK = Short.MAX_VALUE;
    static final int F16_SIGN_SHIFT = 15;
    static final int F16_EXPONENT_SHIFT = 9;
    static final int F16_MANTISSA_SHIFT = 0;
    static final int F16_SIGN_TOGGLE = 32768;
    static final int F16_EXPONENT_BASE = 31;
    static final int F16_MANTISSA_BASE = 512;
    static final int F16_MANTISSA_OVERFLOW = 1024;
    static final int F16_PRODUCT_LIMIT = 524288;
    static final int F16_PRODUCT_ROUND = 256;
    static final String F16_OVERFLOW = "F16 Overflow";
    static final String F16_UNDERFLOW = "F16 Underflow";
    static final String F32_OVERFLOW = "F32 Overflow";
    static final String F32_UNDERFLOW = "F32 Underflow";

    static float bitsToFloat(int bits) {
        if (Float16Imp.getMagnitudeOf(bits) == 0) {
            return 0.0f;
        }
        return Float16Imp.makeFloat32(Float16Imp.getSignOf(bits), Float16Imp.getExponentOf(bits), Float16Imp.getMantissaOf(bits) << 14);
    }

    static int floatToBits(float fval) {
        if (fval == 0.0f) {
            return 0;
        }
        int f32bits = Float.floatToIntBits(fval);
        int sign = Float16Imp.getF32SignOf(f32bits);
        int exponent = Float16Imp.getF32ExponentOf(f32bits);
        int mantissa = Float16Imp.getF32MantissaOf(f32bits);
        mantissa >>= 13;
        ++mantissa;
        if (((mantissa >>= 1) & 0x400) != 0) {
            mantissa >>= 1;
            ++exponent;
        }
        return Float16Imp.makeFloat16(sign, exponent, mantissa);
    }

    private static int getF32SignOf(int bits) {
        return bits >> 31 & 1;
    }

    private static int getF32ExponentOf(int bits) {
        return (bits >> 23 & 0xFF) - 127;
    }

    private static int getF32MantissaOf(int bits) {
        return bits >> 0 & 0x7FFFFF | 0x800000;
    }

    private static int getSignOf(int bits) {
        return bits >> 15 & 1;
    }

    private static int getExponentOf(int bits) {
        return (bits >> 9 & 0x3F) - 31;
    }

    private static int getMantissaOf(int bits) {
        return bits >> 0 & 0x1FF | 0x200;
    }

    private static int getMagnitudeOf(int bits) {
        return bits & Short.MAX_VALUE;
    }

    protected static void F16error(String errMsg) {
    }

    private static int makeFloat16(int sign, int exponent, int mantissa) {
        if ((exponent += 31) <= 0) {
            Float16Imp.F16error(F16_UNDERFLOW);
            return 0;
        }
        if (exponent >= 63) {
            Float16Imp.F16error(F16_OVERFLOW);
            exponent = 62;
            mantissa = 511;
        }
        int ival = (sign & 1) << 15 | (exponent & 0x3F) << 9 | (mantissa & 0x1FF) << 0;
        return ival;
    }

    private static float makeFloat32(int sign, int exponent, int mantissa) {
        if ((exponent += 127) <= 0) {
            Float16Imp.F16error(F32_UNDERFLOW);
            return 0.0f;
        }
        if (exponent >= 255) {
            Float16Imp.F16error(F32_OVERFLOW);
            exponent = 254;
            mantissa = 0x7FFFFF;
        }
        int f32bits = (sign & 1) << 31 | (exponent & 0xFF) << 23 | (mantissa & 0x7FFFFF) << 0;
        return Float.intBitsToFloat(f32bits);
    }
}

