/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.EndianWriter;
import ca.nanometrics.util.LittleEndian;

public class LittleEndianWriter
implements EndianWriter {
    private byte[] buffer;
    private int offset;

    public LittleEndianWriter(byte[] aBuffer, int anOffset) {
        this.buffer = aBuffer;
        this.offset = anOffset;
    }

    public LittleEndianWriter(byte[] aBuffer) {
        this(aBuffer, 0);
    }

    public void setOffset(int newOffset) {
        this.offset = newOffset;
    }

    public void write(byte[] barray, int start, int bytesToWrite) {
        System.arraycopy(barray, start, this.buffer, this.offset, bytesToWrite);
        this.offset += bytesToWrite;
    }

    public void write(byte[] barray) {
        this.write(barray, 0, barray.length);
    }

    public void writeInt(int value) {
        LittleEndian.writeInt(this.buffer, this.offset, value);
        this.offset += 4;
    }

    public void writeByte(byte value) {
        this.buffer[this.offset] = value;
        ++this.offset;
    }

    public void writeShort(short value) {
        LittleEndian.writeShort(this.buffer, this.offset, value);
        this.offset += 2;
    }

    public void writeLong(long value) {
        LittleEndian.writeLong(this.buffer, this.offset, value);
        this.offset += 8;
    }

    public void writeInt24(int value) {
        LittleEndian.writeInt24(this.buffer, this.offset, value);
        this.offset += 3;
    }

    public void writeFloat(float value) {
        LittleEndian.writeFloat(this.buffer, this.offset, value);
        this.offset += 4;
    }

    public void writeDouble(double value) {
        LittleEndian.writeDouble(this.buffer, this.offset, value);
        this.offset += 8;
    }

    public void writeString(String str, int len) {
        LittleEndian.writeString(this.buffer, this.offset, str, len);
        this.offset += len;
    }
}

