/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Log;
import ca.nanometrics.util.Stoppable;
import ca.nanometrics.util.WdgCounter;

public abstract class Runner
implements Runnable,
Stoppable {
    final int WDG_STARTUP_TIMEOUT = 10;
    private String name;
    private Thread t = null;
    private int priority = 5;
    protected boolean stayAlive = false;
    private boolean isDaemon = false;
    private WdgCounter wdgCounter = new WdgCounter();

    public Runner(String threadName) {
        this.name = threadName;
        if (this.name == null) {
            String temp = this.getClass().getName();
            this.name = temp.substring(1 + temp.lastIndexOf(46), temp.length());
        }
    }

    public Runner() {
        this(null);
    }

    public void setDaemon(boolean on) {
        this.isDaemon = on;
    }

    public abstract void run();

    public boolean isAlive() {
        return this.t != null && this.t.isAlive();
    }

    public void setPriority(int newPriority) {
        if (newPriority > 10) {
            newPriority = 10;
        }
        if (newPriority < 1) {
            newPriority = 1;
        }
        this.priority = newPriority;
        this.setThreadPriority();
    }

    private synchronized void setThreadPriority() {
        if (this.t != null) {
            try {
                this.t.setPriority(this.priority);
            }
            catch (Exception e) {
                Log.report(this, 1, 3, "Cannot set thread priority");
            }
        }
    }

    public int getPriority() {
        if (this.t != null) {
            return this.t.getPriority();
        }
        return 0;
    }

    public void start() {
        if (this.isAlive()) {
            throw new IllegalThreadStateException("Runner");
        }
        this.setWdgTimeout(10);
        this.stayAlive = true;
        this.t = new Thread((Runnable)this, this.name);
        this.setThreadPriority();
        this.t.setDaemon(this.isDaemon);
        this.t.start();
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean doJoin) {
        if (this.isAlive()) {
            this.stayAlive = false;
            this.interrupt();
            if (doJoin) {
                try {
                    this.t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.t = null;
    }

    public void restart() {
        this.stop(true);
        this.start();
    }

    public void interrupt() {
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    public void join() throws InterruptedException {
        if (this.t != null) {
            this.t.join();
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setWdgTimeout(int val) {
        this.wdgCounter.set(val);
    }

    public boolean isRunningOk() {
        return this.isAlive() && this.wdgCounter.test();
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

