/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

public class TextFilter {
    private String filterString;
    private String description;

    public TextFilter(String filter, String name) {
        this.filterString = filter;
        this.description = name;
    }

    public TextFilter(String filter) {
        this(filter, filter);
    }

    public String getFilter() {
        return this.filterString;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accepts(String text) {
        return TextFilter.match(this.filterString, text);
    }

    public static boolean match(String filter, String text) {
        if (filter == null || text == null) {
            return false;
        }
        if (filter.length() == 0) {
            return text.length() == 0;
        }
        if (filter.equals("*")) {
            return true;
        }
        if (filter.startsWith("*")) {
            String newFilter = filter.substring(1);
            int ix = 0;
            while (ix <= text.length()) {
                if (TextFilter.match(newFilter, text.substring(ix))) {
                    return true;
                }
                ++ix;
            }
            return false;
        }
        if (text.length() < 1) {
            return false;
        }
        if (filter.startsWith("?") || filter.charAt(0) == text.charAt(0)) {
            return TextFilter.match(filter.substring(1), text.substring(1));
        }
        return false;
    }
}

