/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.coyote.io;

import cn.org.gddsn.coyote.io.ObjectDatabaseCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

public class ObjectDatabaseFile {
    private static final long DEL_LIST_END = -1L;
    private static final byte IS_DELETED = 0;
    private static final byte IS_ACTIVE = 1;
    private RandomAccessFile dataFile;
    private String fileName;
    private long firstDel;

    public ObjectDatabaseFile(String name) throws IOException {
        this.fileName = new String(name);
        this.dataFile = new RandomAccessFile(name, "rw");
        this.constructorHelper();
    }

    public ObjectDatabaseFile(File file) throws IOException {
        this.fileName = new String(file.getName());
        this.dataFile = new RandomAccessFile(this.fileName, "rw");
        this.constructorHelper();
    }

    private void constructorHelper() throws IOException {
        if (this.dataFile.length() == 0L) {
            this.dataFile.writeLong(-1L);
            this.firstDel = -1L;
        } else {
            this.firstDel = this.dataFile.readLong();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.dataFile.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.dataFile.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.dataFile.seek(pos);
    }

    public long length() throws IOException {
        return this.dataFile.length();
    }

    public void close() throws IOException {
        this.dataFile.close();
    }

    public long writeObject(Object obj) throws IOException {
        int datalen;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream ostrm = new ObjectOutputStream(bytes);
        ostrm.writeObject(obj);
        ostrm.flush();
        int reclen = datalen = bytes.size();
        long pos = 0L;
        if (this.firstDel == -1L) {
            pos = this.dataFile.length();
            this.dataFile.seek(pos);
        } else {
            long prev = -1L;
            pos = this.firstDel;
            while (true) {
                this.dataFile.seek(pos);
                byte deleted = this.dataFile.readByte();
                this.dataFile.readInt();
                reclen = this.dataFile.readInt();
                long next = this.dataFile.readLong();
                if (deleted == 1) {
                    throw new IOException("corrupt delete list");
                }
                if (reclen >= datalen) {
                    if (prev == -1L) {
                        this.firstDel = next;
                        this.dataFile.seek(0L);
                        this.dataFile.writeLong(this.firstDel);
                    } else {
                        this.dataFile.seek(prev + 1L + 4L + 4L);
                        this.dataFile.writeLong(next);
                    }
                    this.dataFile.seek(pos);
                    break;
                }
                prev = pos;
                if (next == -1L) {
                    pos = this.dataFile.length();
                    this.dataFile.seek(pos);
                    break;
                }
                pos = next;
            }
        }
        this.dataFile.writeByte(1);
        this.dataFile.writeInt(datalen);
        this.dataFile.writeInt(reclen);
        this.dataFile.writeLong(-1L);
        this.dataFile.write(bytes.toByteArray());
        return pos;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        byte deleted;
        while ((deleted = this.dataFile.readByte()) != 1) {
            this.dataFile.skipBytes(4);
            int n = this.dataFile.readInt();
            this.dataFile.skipBytes(n + 8);
        }
        int datalen = this.dataFile.readInt();
        int reclen = this.dataFile.readInt();
        this.dataFile.skipBytes(8);
        byte[] data = new byte[datalen];
        this.dataFile.readFully(data);
        int diff = reclen - datalen;
        if (diff > 0) {
            this.dataFile.skipBytes(diff);
        }
        ByteArrayInputStream bytes = new ByteArrayInputStream(data);
        ObjectInputStream istrm = new ObjectInputStream(bytes);
        return istrm.readObject();
    }

    public void delete() throws IOException {
        long pos = this.dataFile.getFilePointer();
        byte deleted = this.dataFile.readByte();
        if (deleted == 0) {
            return;
        }
        this.dataFile.seek(pos);
        this.dataFile.writeByte(0);
        this.dataFile.skipBytes(8);
        this.dataFile.writeLong(this.firstDel);
        this.firstDel = pos;
        this.dataFile.seek(0L);
        this.dataFile.writeLong(this.firstDel);
    }

    public void rewind() throws IOException {
        this.dataFile.seek(8L);
    }

    public void skip() throws IOException {
        this.dataFile.skipBytes(5);
        int reclen = this.dataFile.readInt();
        this.dataFile.skipBytes(8 + reclen);
    }

    public void compact(ObjectDatabaseCallback callback) throws IOException, Throwable {
        File tempName = new File("TMP" + System.currentTimeMillis());
        RandomAccessFile newFile = new RandomAccessFile(tempName, "rw");
        newFile.writeLong(-1L);
        this.rewind();
        try {
            while (true) {
                byte deleted = this.dataFile.readByte();
                int dataLen = this.dataFile.readInt();
                int recLen = this.dataFile.readInt();
                if (deleted == 0) {
                    this.dataFile.skipBytes(8 + recLen);
                    continue;
                }
                this.dataFile.skipBytes(8);
                byte[] data = new byte[dataLen];
                this.dataFile.readFully(data);
                int diff = recLen - dataLen;
                if (diff > 0) {
                    this.dataFile.skipBytes(diff);
                }
                long pos = newFile.getFilePointer();
                newFile.writeByte(1);
                newFile.writeInt(dataLen);
                newFile.writeInt(dataLen);
                newFile.writeLong(-1L);
                newFile.write(data);
                ByteArrayInputStream bytes = new ByteArrayInputStream(data);
                ObjectInputStream istrm = new ObjectInputStream(bytes);
                if (callback == null) continue;
                callback.compactNotify(pos, istrm.readObject());
            }
        }
        catch (EOFException eof) {
        }
        catch (Throwable ex) {
            throw ex;
        }
        this.dataFile.close();
        File goAway = new File(this.fileName);
        goAway.delete();
        newFile.close();
        tempName.renameTo(new File(this.fileName));
        this.dataFile = new RandomAccessFile(this.fileName, "rw");
        this.constructorHelper();
    }
}

