/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.db;

import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class ConnectionPool {
    static Logger logger;
    private PoolInfo poolInfo = new PoolInfo();
    Properties jdbcProperties;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.db.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public boolean initialize(String name) throws Exception {
        this.loadConfig(name);
        try {
            Class.forName(this.poolInfo.jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            logger.warn(e.getMessage(), e);
        }
        this.setupDriver();
        return true;
    }

    public boolean initialize(PoolInfo info) throws Exception {
        this.poolInfo = info;
        if (this.poolInfo.poolName == null) {
            this.poolInfo.poolName = "POOL";
        }
        try {
            Class.forName(this.poolInfo.jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            logger.warn(e.getMessage(), e);
        }
        this.setupDriver();
        return true;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.poolInfo.poolName);
        }
        catch (SQLException e) {
            logger.warn(e.getMessage(), e);
        }
        return conn;
    }

    public String printPoolStatus() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("--ConnectionPool--\r\n");
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            ObjectPool connectionPool = driver.getConnectionPool(this.poolInfo.poolName);
            sbuf.append("NumActive: " + connectionPool.getNumActive() + "\r\n");
            sbuf.append("NumIdle: " + connectionPool.getNumIdle() + "\r\n");
        }
        catch (SQLException e) {
            logger.warn(e.getMessage(), e);
        }
        return sbuf.toString();
    }

    private void setupDriver() throws Exception {
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.poolInfo.jdbcConnectionURL, this.poolInfo.jdbcUser, this.poolInfo.jdbcPassword);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, null, null, false, true);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(this.poolInfo.poolName, connectionPool);
    }

    public void printDriverStats() throws Exception {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        ObjectPool connectionPool = driver.getConnectionPool(this.poolInfo.poolName);
        logger.info("NumActive: " + connectionPool.getNumActive());
        logger.info("NumIdle: " + connectionPool.getNumIdle());
    }

    public void destroy() {
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            driver.closePool(this.poolInfo.poolName);
        }
        catch (SQLException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    private boolean loadConfig(String name) throws Exception {
        boolean rc = false;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream in = cl != null ? cl.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        if (in == null) {
            in = new FileInputStream(name);
        }
        if (in == null) {
            throw new Exception("ConnectionPool configuration file '" + name + "' not found");
        }
        try {
            this.jdbcProperties = new Properties();
            Properties allProperties = new Properties();
            allProperties.load(in);
            ((Hashtable)this.jdbcProperties).put("JDBCDriver", allProperties.getProperty("JDBCDriver"));
            ((Hashtable)this.jdbcProperties).put("JDBCConnectionURL", allProperties.getProperty("JDBCConnectionURL"));
            ((Hashtable)this.jdbcProperties).put("User", allProperties.getProperty("User"));
            ((Hashtable)this.jdbcProperties).put("Password", allProperties.getProperty("Password"));
            ((Hashtable)this.jdbcProperties).put("PoolName", allProperties.getProperty("PoolName"));
            ((Hashtable)allProperties).clear();
            this.poolInfo.jdbcDriver = this.consume(this.jdbcProperties, "JDBCDriver");
            this.poolInfo.jdbcConnectionURL = this.consume(this.jdbcProperties, "JDBCConnectionURL");
            this.poolInfo.jdbcUser = this.consume(this.jdbcProperties, "User");
            this.poolInfo.jdbcPassword = this.consume(this.jdbcProperties, "Password");
            this.poolInfo.poolName = this.consume(this.jdbcProperties, "PoolName");
            if (this.poolInfo.poolName == null) {
                this.poolInfo.poolName = "POOL";
            }
            rc = true;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return rc;
    }

    private String consume(Properties p, String key) {
        String s = null;
        if (p != null && key != null && (s = p.getProperty(key)) != null) {
            ((Hashtable)p).remove(key);
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        ConnectionPool pool;
        block29: {
            pool = new ConnectionPool();
            pool.initialize("/tmp/IPDiscover.properties");
            Connection conn = null;
            Statement stmt = null;
            ResultSet rset = null;
            try {
                try {
                    System.out.println("Creating connection.");
                    conn = pool.getConnection();
                    System.out.println("Creating statement.");
                    stmt = conn.createStatement();
                    System.out.println("Executing statement.");
                    rset = stmt.executeQuery("select * from user");
                    System.out.println("Results:");
                    int numcols = rset.getMetaData().getColumnCount();
                    while (rset.next()) {
                        int i = 1;
                        while (i <= numcols) {
                            System.out.print("\t" + rset.getString(i));
                            ++i;
                        }
                        System.out.println("");
                    }
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), e);
                    try {
                        rset.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                    break block29;
                }
            }
            catch (Throwable throwable) {
                try {
                    rset.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                rset.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            pool.printDriverStats();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            pool.destroy();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public void setPoolInfo(PoolInfo pool) throws Exception {
        this.poolInfo = pool;
        this.initialize(this.poolInfo);
    }

    public PoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public static class PoolInfo {
        public String jdbcDriver;
        public String jdbcConnectionURL;
        public String jdbcUser;
        public String jdbcPassword;
        public String poolName = "POOL";

        public String getJdbcConnectionURL() {
            return this.jdbcConnectionURL;
        }

        public String getJdbcDriver() {
            return this.jdbcDriver;
        }

        public String getJdbcPassword() {
            return this.jdbcPassword;
        }

        public String getJdbcUser() {
            return this.jdbcUser;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public void setJdbcUser(String jdbcUser) {
            this.jdbcUser = jdbcUser;
        }

        public void setJdbcPassword(String jdbcPassword) {
            this.jdbcPassword = jdbcPassword;
        }

        public void setJdbcDriver(String jdbcDriver) {
            this.jdbcDriver = jdbcDriver;
        }

        public void setJdbcConnectionURL(String jdbcConnectionURL) {
            this.jdbcConnectionURL = jdbcConnectionURL;
        }
    }
}

