/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends FilterInputStream {
    private static final int BITS_PER_BYTE = 8;
    private int bit8;
    private int idx = -1;

    public BitInputStream(InputStream in) {
        super(in);
    }

    public int readBit() throws IOException {
        if (this.idx < 0) {
            this.bit8 = this.in.read();
            if (this.bit8 == -1) {
                throw new EOFException();
            }
            this.idx = 0;
        } else if (this.idx == 7) {
            this.idx = -1;
            return this.bit8 >>> 7;
        }
        return this.bit8 >>> this.idx++ & 1;
    }

    public int read() throws IOException {
        return this.readByte();
    }

    public int readByte() throws IOException {
        return this.readBits(8);
    }

    public int readInt12() throws IOException {
        return this.readBits(12);
    }

    public int readInt24() throws IOException {
        return this.readBits(24);
    }

    public int readInt() throws IOException {
        return this.readBits(32);
    }

    public long readLong() throws IOException {
        return this.readBits(64);
    }

    public int readBits(int len) throws IOException {
        int bits = 0;
        int i = 0;
        while (i < len) {
            bits += this.readBit() << i;
            ++i;
        }
        return bits;
    }

    public int readSignedBits(int len) throws IOException {
        int bits = 0;
        int i = 0;
        while (i < len - 1) {
            bits += this.readBit() << i;
            ++i;
        }
        if (this.readBit() == 0) {
            return bits;
        }
        return (bits += 1 << len - 1) - (1 << len);
    }
}

