/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public abstract class ConsoleLogger {
    private PipedInputStream pin = null;
    private PipedOutputStream pout = null;
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private Thread messageThread = null;
    private boolean finished = false;
    private boolean bDebug = true;

    public ConsoleLogger() {
        this.run();
    }

    public abstract void addMessage(String var1);

    public void setDebug(boolean bDebug) {
        this.bDebug = bDebug;
    }

    public void run() {
        try {
            this.finished = false;
            this.stdout = System.out;
            this.stderr = System.err;
            this.pin = new PipedInputStream();
            this.pout = new PipedOutputStream(this.pin);
            PrintStream prs = new PrintStream(this.pout);
            System.setOut(prs);
            System.setErr(prs);
            this.messageThread = new Thread(){

                public synchronized void run() {
                    Thread.currentThread().setPriority(1);
                    BufferedReader br = new BufferedReader(new InputStreamReader(ConsoleLogger.this.pin));
                    String nextline = "";
                    while (!ConsoleLogger.this.finished) {
                        try {
                            try {
                                this.wait(200L);
                            }
                            catch (InterruptedException interruptedException) {}
                            while (br.ready()) {
                                nextline = br.readLine();
                                if (!ConsoleLogger.this.bDebug) continue;
                                ConsoleLogger.this.addMessage(nextline);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.messageThread.setName("Console Output Logger");
            this.messageThread.start();
        }
        catch (IOException x) {
            System.out.println(x);
        }
    }

    public void clear() {
    }

    public void stop() {
        this.close();
    }

    protected void close() {
        this.finished = true;
        System.setOut(this.stdout);
        System.setErr(this.stderr);
        try {
            this.pout.close();
        }
        catch (IOException x) {
            System.out.println("Logger.close: " + x);
        }
    }
}

