/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
        this.written += length;
    }

    public final void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    public final void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeChar(int c) throws IOException {
        this.out.write(c & 0xFF);
        this.out.write(c >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeInt24(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >>> 8 & 0xFF);
        this.out.write(i >>> 16 & 0xFF);
        this.written += 3;
    }

    public final void writeInt(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >>> 8 & 0xFF);
        this.out.write(i >>> 16 & 0xFF);
        this.out.write(i >>> 24 & 0xFF);
        this.written += 4;
    }

    public final void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String s) throws IOException {
        int length = s.length();
        int i = 0;
        while (i < length) {
            this.out.write((byte)s.charAt(i));
            ++i;
        }
        this.written += length;
    }

    public final void writeBytes(byte[] s, int len) throws IOException {
        int length = s.length;
        if (len < length) {
            int i = 0;
            while (i < len) {
                this.out.write(s[i]);
                ++i;
            }
            this.written += len;
            return;
        }
        int i = 0;
        while (i < length) {
            this.out.write(s[i]);
            ++i;
        }
        this.written += length;
        i = 0;
        while (i < len - length) {
            this.out.write(0);
            ++this.written;
            ++i;
        }
    }

    public final void writeBytes(String s, int len) throws IOException {
        this.writeBytes(s.getBytes(), len);
    }

    public final void writeChars(String s) throws IOException {
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
            ++i;
        }
        this.written += length * 2;
    }

    public final void writeUTF(String s) throws IOException {
        char c;
        int strlen = s.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = s.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(utflen & 0xFF);
        this.out.write(utflen >>> 8 & 0xFF);
        i = 0;
        while (i < strlen) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.out.write(c);
            } else if (c > '\u07ff') {
                this.out.write(0x80 | c & 0x3F);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0xE0 | c >> 12 & 0xF);
                this.written += 2;
            } else {
                this.out.write(0x80 | c & 0x3F);
                this.out.write(0xC0 | c >> 6 & 0x1F);
                ++this.written;
            }
            ++i;
        }
        this.written += strlen + 2;
    }

    public final int size() {
        return this.written;
    }
}

