/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.client;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.service.EventManagerService;
import cn.org.gddsn.util.Log4jConfig;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class Eqim
implements MessageListener {
    static Logger logger = Logger.getLogger(Eqim.class);
    private JmsTemplate jmsTemplate;
    private EventManagerService eventManagerService;
    private DefaultMessageListenerContainer container;
    private String mode = "send";
    transient PropertyChangeSupport alarmBrokenSupport = new PropertyChangeSupport(this);

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.alarmBrokenSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.alarmBrokenSupport.addPropertyChangeListener(l);
    }

    public void run() {
        if (this.mode.equals("receive")) {
            this.container.start();
            logger.info("Receiving");
        } else if (this.mode.equals("send")) {
            this.container.shutdown();
            this.send(this.readUniEventId("1"));
        }
    }

    public void onMessage(Message message) {
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)message;
            try {
                int size = (int)bm.getBodyLength();
                byte[] buf = new byte[size];
                bm.readBytes(buf);
                try {
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));
                    UniEventId uniEventId = (UniEventId)ois.readObject();
                    if (uniEventId == null) {
                        return;
                    }
                    logger.info("Got UniEventId: " + uniEventId);
                    uniEventId.setNationEventId("0");
                    for (EventInfo info : uniEventId.getEventInfos()) {
                        info.setEventId("0");
                        for (Catalog cata : info.getCatalogs()) {
                            String magTD;
                            for (Mag mag : cata.getMags()) {
                                mag.setId(0L);
                                magTD = mag.getMagType().getId();
                                mag.setMagType(this.eventManagerService.findMagTypeById(magTD));
                            }
                            for (Phase phase : cata.getPhases()) {
                                phase.setId(0L);
                                magTD = phase.getMagtypeDic().getId();
                                phase.setMagtypeDic(this.eventManagerService.findMagTypeById(magTD));
                            }
                        }
                    }
                    if (bm.getJMSDestination().toString().equals("CB")) {
                        this.writeUniEventId(uniEventId);
                    } else {
                        this.writeUniEventId(uniEventId);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.alarmBrokenSupport.firePropertyChange("alarmEvent", "", "");
            }
            catch (JMSException ex) {
                logger.warn(ex.getMessage(), ex);
            }
        }
    }

    public void send(final UniEventId uniEventId) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage bmsg = session.createBytesMessage();
                ByteArrayOutputStream bai = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(bai);
                    oos.writeObject(uniEventId);
                    oos.close();
                    bai.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                bmsg.writeBytes(bai.toByteArray());
                bmsg.setJMSDeliveryMode(2);
                return bmsg;
            }
        });
        logger.info("sent 1 UniEventId");
    }

    public UniEventId readUniEventId(String id) {
        logger.info("read uniEventId from DB.");
        return this.eventManagerService.findUniEventIdById(id);
    }

    public void writeUniEventId(UniEventId uniEventId) {
        logger.info("write uniEventId to DB.");
        this.eventManagerService.addUniEventId(uniEventId);
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public DefaultMessageListenerContainer getContainer() {
        return this.container;
    }

    public void setContainer(DefaultMessageListenerContainer container) {
        this.container = container;
    }

    public EventManagerService getEventManagerService() {
        return this.eventManagerService;
    }

    public void setEventManagerService(EventManagerService eventManagerService) {
        this.eventManagerService = eventManagerService;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("log4j.properties");
        FileSystemResource res = new FileSystemResource("JOPENS-service.xml");
        XmlBeanFactory ac = new XmlBeanFactory(res);
        Eqim eqim = (Eqim)ac.getBean("eqim");
        eqim.setMode("receive");
        eqim.setMode(args[0]);
        eqim.run();
        if (eqim.getMode().equals("receive")) {
            try {
                Thread.sleep(3600000L);
            }
            catch (Exception exception) {}
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(-1);
    }
}

