/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.client;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogI;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.WaveformEvent;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.SeedVolumeMgrService;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class SeedVolumeImporter {
    static Logger logger = Logger.getLogger(SeedVolumeImporter.class);
    private Dataless dataless = null;
    private byte[] buf = new byte[8192];
    private int trIdx = 0;
    private SeedVolumeMgrService seedVolumeMgrService;

    public void clearStationAndEvent() {
        this.seedVolumeMgrService.clearStationAndEvent();
    }

    public Catalog generateDefaultCatalog(String catalogId, String eventId, String netCode) {
        CatalogI c = new CatalogI();
        c.setId(catalogId);
        c.setNetCode(netCode);
        c.setCataName("imported");
        return c;
    }

    public boolean importIt(InputStream in) throws IOException {
        boolean success = false;
        this.dataless = new Dataless();
        success = this.dataless.readSeedVolumeDataless(new PushbackInputStream(in, 4096));
        if (!success) {
            return success;
        }
        long id = this.seedVolumeMgrService.writeDataless(this.dataless);
        Dataless remoteDataless = this.seedVolumeMgrService.findDatalessById(id);
        if (remoteDataless != null) {
            this.dataless = remoteDataless;
            NetworkInfo ni = this.seedVolumeMgrService.findNetworkInfoSelf();
            if (ni == null) {
                ni = new NetworkInfo();
                ni.setId("GD");
                ni.setUniCode(this.dataless.getId());
                ni.setSelf('Y');
                this.seedVolumeMgrService.writeNetworkInfo(ni);
            }
        }
        HashMap<String, Channel> maps = new HashMap<String, Channel>(512);
        for (Station sta : this.dataless.getSeedConfig().getStation()) {
            for (Channel chn : sta.getChannel()) {
                String cl = String.valueOf(sta.getBlockette050().getNetworkCode()) + "/" + sta.getBlockette050().getStation();
                cl = String.valueOf(cl) + "/" + chn.getBlockette052().getLocation() + "/" + chn.getBlockette052().getChannel();
                maps.put(cl, chn);
            }
        }
        EventInfo eventInfo = new EventInfo();
        eventInfo.setEventId("GD.200708201654.0001");
        eventInfo.setStartTime(this.dataless.getVolumeIndex().getBlockette010().getStartTime());
        eventInfo.setEndTime(this.dataless.getVolumeIndex().getBlockette010().getEndTime());
        eventInfo.setDataless(this.dataless);
        eventInfo.setUniEventId(null);
        LinkedList<Catalog> catalogs = new LinkedList<Catalog>();
        eventInfo.setCatalogs(catalogs);
        catalogs.add(this.generateDefaultCatalog("GD.200708201654.0001.I.0001", "GD.200708201654.0001", "GD"));
        HashSet<WaveformEvent> waveformSet = new HashSet<WaveformEvent>();
        eventInfo.setWaveformEvents(waveformSet);
        GenericMiniSeedRecord gmsr = null;
        while ((gmsr = this.getNextMiniSeedData(in)) != null) {
            WaveformEvent wfe = new WaveformEvent(gmsr);
            wfe.setChannel((Channel)maps.get(wfe.getChannelLocator().toString()));
            wfe.setEventInfo(eventInfo);
            waveformSet.add(wfe);
        }
        long ct = System.currentTimeMillis();
        this.seedVolumeMgrService.writeEventInfo(eventInfo);
        System.out.println("insert time: " + (System.currentTimeMillis() - ct) / 1000L);
        return success;
    }

    /*
     * Exception decompiling
     */
    private GenericMiniSeedRecord getNextMiniSeedData(InputStream in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) throws Exception {
        FileSystemResource res = new FileSystemResource("SeedVolumeMgrService.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        SeedVolumeMgrService service = (SeedVolumeMgrService)factory.getBean("seedVolumeMgrService");
        long ct = System.currentTimeMillis();
        SeedVolumeImporter importer = new SeedVolumeImporter();
        importer.setSeedVolumeMgrService(service);
        importer.clearStationAndEvent();
        System.out.println("insert time: " + (System.currentTimeMillis() - ct) / 1000L);
    }

    public SeedVolumeMgrService getSeedVolumeMgrService() {
        return this.seedVolumeMgrService;
    }

    public void setSeedVolumeMgrService(SeedVolumeMgrService seedVolumeMgrService) {
        this.seedVolumeMgrService = seedVolumeMgrService;
    }
}

