/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.client;

import cn.org.gddsn.jopens.entity.InstrDic;
import cn.org.gddsn.jopens.entity.InstruManage;
import cn.org.gddsn.jopens.entity.NetStation;
import cn.org.gddsn.jopens.entity.StationCorr;
import cn.org.gddsn.jopens.entity.StationInfo;
import cn.org.gddsn.jopens.entity.StationSite;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Station;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class StationInfoUtil {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Station buildStation(String net, String stn) {
        Station station = new Station();
        station.setBlockette050(StationInfoUtil.buildBlockette050(net, stn));
        station.setStationInfo(StationInfoUtil.buildStationInfo(net, stn));
        StationCorr corr = StationInfoUtil.buildStationCorr(net, stn);
        StationSite site = StationInfoUtil.buildStationSite(net, stn);
        station.setStationCorr(corr);
        station.setStationSite(site);
        return station;
    }

    public static Blockette050 buildBlockette050(String net, String stn) {
        Blockette050 b050 = new Blockette050();
        b050.setNumberOfChannels(0);
        b050.setStation(net);
        b050.setStation(stn);
        try {
            b050.setStartTime(new Timestamp(sdf.parse("2006-01-01 00:00:00").getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        b050.setWordOrder32("3210");
        b050.setWordOrder16("10");
        b050.setUpdateFlag('N');
        return b050;
    }

    public static StationInfo buildStationInfo(String net, String stn) {
        StationInfo sta = new StationInfo();
        NetStation ns = new NetStation();
        ns.setNetCode(net);
        ns.setStaCode(stn);
        sta.setNetStation(ns);
        sta.setBuildType("");
        sta.setChanNum(3);
        sta.setCoordsys("WGS-84");
        sta.setHost("0.0.0.0");
        sta.setInstrGateway("0.0.0.0");
        sta.setInstrMask("255.255.255.0");
        sta.setLocaldepth(0.0f);
        sta.setNumericCode("12345");
        try {
            sta.setOndate(sdf.parse("2006-01-01 00:00:00"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sta.setOffdate(null);
        sta.setPassword("xxx");
        sta.setPortNumber(5000);
        sta.setRockType("\u57fa\u5ca9");
        sta.setSiteName("\u5730\u5740\u63cf\u8ff0");
        sta.setStaCname("");
        sta.setStaElev(1000.0f);
        sta.setStaLat(21.0f);
        sta.setStaLon(112.0f);
        sta.setStaLevel("\u533a\u57df");
        sta.setStaSname("station");
        sta.setStaType("\u56fa\u5b9a");
        sta.setTimerMode("GPS");
        sta.setTransmitInter("");
        sta.setUserName("root");
        return sta;
    }

    public static Channel buildChannel(String locId, String chan) {
        Channel chn = new Channel();
        chn.setBlockette052(StationInfoUtil.buildBlockette052(locId, chan));
        return chn;
    }

    public static Blockette052 buildBlockette052(String locId, String chan) {
        Blockette052 chn = new Blockette052();
        chn.setLocation(locId);
        chn.setAzimuth(-0.0);
        chn.setDip(0.0);
        chn.setSampleRate(100.0);
        try {
            chn.setStartTime(new Timestamp(sdf.parse("2005-01-01 00:00:00").getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        chn.setEndTime(null);
        return chn;
    }

    public static StationSite buildStationSite(String net, String stn) {
        StationSite site = new StationSite();
        site.setEventNum(0);
        site.setOperator("");
        site.setSite("");
        NetStation ns = new NetStation();
        ns.setNetCode(net);
        ns.setStaCode(stn);
        site.setNetStation(ns);
        try {
            site.setCreateDate(sdf.parse("2005-01-12 00:00:00"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return site;
    }

    public static StationCorr buildStationCorr(String net, String stn) {
        StationCorr corr = new StationCorr();
        corr.setMagCorr(0.0f);
        NetStation ns = new NetStation();
        ns.setNetCode(net);
        ns.setStaCode(stn);
        corr.setNetStation(ns);
        corr.setPhaseCorrP(0.0f);
        corr.setPhaseCorrS(0.0f);
        try {
            corr.setOndate(sdf.parse("2005-01-01 00:00:00"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        corr.setOffdate(null);
        return corr;
    }

    public static InstruManage buildInstruManage(String net, String stn) {
        InstruManage im = new InstruManage();
        im.setInstruSeq("");
        im.setMac("00:00:00:00:00:00");
        NetStation ns = new NetStation();
        ns.setNetCode(net);
        ns.setStaCode(stn);
        im.setNetStation(ns);
        try {
            im.setOndate(sdf.parse("2005-01-01 00:00:00"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        im.setOffdate(null);
        return im;
    }

    public static InstrDic buildInstrDic(String type, String model) {
        InstrDic ins = new InstrDic();
        ins.setInstrModel(model);
        ins.setInstrType(type);
        ins.setInstrVer("");
        ins.setManufacturer("");
        ins.setAddressOfM("");
        ins.setCommunicationOfM("");
        ins.setSupplier("");
        ins.setAddressOfS("");
        ins.setCommunicationOfS("");
        return ins;
    }

    public static Blockette034 buildBlockette034(String unitName, String disc) {
        Blockette034 units = new Blockette034();
        units.setUnitName(unitName);
        units.setUnitDescription(disc);
        return units;
    }
}

