/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public final class ChannelLocator
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7350936965483961416L;
    @Column(name="Net_code", length=2, nullable=false)
    private String netCode = "";
    @Column(name="Sta_code", length=5, nullable=false)
    private String stationCode = "";
    @Column(name="Loc_id", length=2, nullable=false)
    private String locId = "00";
    @Column(name="Chn_code", length=3, nullable=false)
    private String chanCode = "";

    public ChannelLocator() {
    }

    public ChannelLocator(String netCode, String StationCode, String locID, String chanCode) {
        this.setChannelLocator(netCode, StationCode, locID, chanCode);
    }

    public static ChannelLocator parse(String chanDiscription) throws NoSuchElementException {
        StringTokenizer sToken = new StringTokenizer(chanDiscription, "/");
        ChannelLocator cl = new ChannelLocator();
        cl.setChannelLocator(sToken.nextToken(), sToken.nextToken(), sToken.nextToken(), sToken.nextToken());
        return cl;
    }

    public static ChannelLocator[] parse(String[] chanDiscription) throws NoSuchElementException {
        ChannelLocator[] cls = new ChannelLocator[chanDiscription.length];
        int i = 0;
        while (i < cls.length) {
            cls[i] = ChannelLocator.parse(chanDiscription[i]);
            ++i;
        }
        return cls;
    }

    public ChannelLocator copy() {
        ChannelLocator cl = new ChannelLocator();
        cl.netCode = new String(this.netCode);
        cl.stationCode = new String(this.stationCode);
        cl.locId = new String(this.locId);
        cl.chanCode = new String(this.chanCode);
        return cl;
    }

    public void setChannelLocator(String netCode, String StationCode, String locID, String chanCode) {
        this.netCode = netCode;
        this.stationCode = StationCode;
        this.locId = locID;
        this.chanCode = chanCode;
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String getLocId() {
        return this.locId;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public void setLocId(String locId) {
        this.locId = locId;
    }

    public int compareTo(Object o) {
        return this.compareTo((ChannelLocator)o);
    }

    public int compareTo(ChannelLocator cl) {
        return this.toString().compareTo(cl.toString());
    }

    public String toString() {
        return String.valueOf(this.netCode) + "/" + this.stationCode + "/" + this.locId + "/" + this.chanCode;
    }

    public String toUnderLineString() {
        return String.valueOf(this.netCode) + "_" + this.stationCode + "_" + this.locId + "_" + this.chanCode;
    }

    public int hashCode() {
        return (String.valueOf(this.netCode) + this.stationCode + this.locId + this.chanCode).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChannelLocator) {
            ChannelLocator obj1 = (ChannelLocator)obj;
            return this.netCode.equals(obj1.netCode) && this.stationCode.equals(obj1.stationCode) && this.locId.equals(obj1.locId) && this.chanCode.equals(obj1.chanCode);
        }
        return false;
    }

    public void setChanCode(String chanCode) {
        this.chanCode = chanCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public static void main(String[] args) {
        ChannelLocator cl = new ChannelLocator("GD", "SHZ", "00", "BHN");
        System.out.println(cl.hashCode());
        cn.org.gddsn.seis.ChannelLocator cl1 = new cn.org.gddsn.seis.ChannelLocator("GD", "SHZ", "00", "BHN");
        System.out.println(cl1.hashCode());
    }
}

