/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.Pick;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="Auto_flag", length=1, discriminatorType=DiscriminatorType.STRING)
public class Phase
implements Serializable,
Comparable {
    private static final long serialVersionUID = 732800459286220349L;
    public static final int AT = 0;
    public static final int MA = 1;
    public static final int FM = 2;
    public static final int SINGLE_AMP = 0;
    public static final int DOUBLE_AMP = 1;
    public static final String ARTI_NONE = "";
    public static final String I = "I";
    public static final String E = "E";
    public static final String BRACKET = "(";
    public static final String SIGN_NONE = "";
    public static final String C = "C";
    public static final String D = "D";
    public static final String U = "U";
    public static final String R = "R";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @ManyToOne
    @JoinColumn(name="Catalog_id")
    private Catalog catalog;
    @Embedded
    private ChannelLocator channelLocator;
    @Column(name="Rec_type", length=10)
    private String recType;
    @Column(name="Phase_name", length=12)
    private String phaseName;
    @Column(name="Phase_type", length=6)
    private String phaseType;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="Phase_time")
    private Date phaseTime;
    @Column(name="Phase_time_frac")
    private int phaseTimeFrac;
    @Column(name="Amp")
    private float amp;
    @Column(name="Amp_type", length=10)
    private String ampType;
    @Column(name="Period")
    private float period;
    @Column(name="Weight")
    private int weight;
    @Column(name="Clarity", length=1)
    private String clarity;
    @Column(name="Wsign", length=1)
    private String wsign;
    @Column(name="Resi")
    private float resi;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="Mag_name", nullable=true)
    private MagType magType;
    @Column(name="Mag_val")
    private float magVal;
    @Column(name="Distance")
    private float distance;
    @Column(name="Azi")
    private float azimuth;
    @Column(name="S_P")
    private float sp;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="Pick_id", nullable=true)
    private Pick pick;

    public Phase() {
        this.fillDefaultValue();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public float getSp() {
        return this.sp;
    }

    public void setSp(float sP) {
        this.sp = sP;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float azi) {
        this.azimuth = azi;
    }

    public String getClarity() {
        return this.clarity;
    }

    public void setClarity(String clarity) {
        this.clarity = clarity;
    }

    public float getMagVal() {
        return this.magVal;
    }

    public void setMagVal(float magVal) {
        this.magVal = magVal;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getWsign() {
        return this.wsign;
    }

    public void setWsign(String wsign) {
        this.wsign = wsign;
    }

    public float getPeriod() {
        return this.period;
    }

    public void setPeriod(float period) {
        this.period = period;
    }

    public String getRecType() {
        return this.recType;
    }

    public void setRecType(String recType) {
        this.recType = recType;
    }

    public String getAmpType() {
        return this.ampType;
    }

    public void setAmpType(String ampType) {
        this.ampType = ampType;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public Date getPhaseTime() {
        return this.phaseTime;
    }

    public void setPhaseTime(Date phaseTime) {
        this.phaseTime = phaseTime;
    }

    public int getPhaseTimeFrac() {
        return this.phaseTimeFrac;
    }

    public void setPhaseTimeFrac(int phaseTimeFrac) {
        this.phaseTimeFrac = phaseTimeFrac;
    }

    public float getAmp() {
        return this.amp;
    }

    public void setAmp(float amp) {
        this.amp = amp;
    }

    public float getResi() {
        return this.resi;
    }

    public void setResi(float resi) {
        this.resi = resi;
    }

    public MagType getMagtypeDic() {
        return this.magType;
    }

    public void setMagtypeDic(MagType magType) {
        this.magType = magType;
    }

    public ChannelLocator getChannelLocator() {
        return this.channelLocator;
    }

    public void setChannelLocator(ChannelLocator channelLocator) {
        this.channelLocator = channelLocator;
    }

    public MagType getMagType() {
        return this.magType;
    }

    public void setMagType(MagType magType) {
        this.magType = magType;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public String getPhaseType() {
        return this.phaseType;
    }

    public void setPhaseType(String phaseType) {
        this.phaseType = phaseType;
    }

    public int compareTo(Object o) {
        Phase anPhase = (Phase)o;
        if (this.distance == anPhase.distance) {
            return this.phaseTime.compareTo(anPhase.phaseTime);
        }
        if (this.distance < anPhase.distance) {
            return -1;
        }
        return 1;
    }

    private void fillDefaultValue() {
        float dv = -99999.0f;
        this.setAmp(dv);
        this.setAmpType(null);
        this.setAzimuth(dv);
        this.setCatalog(null);
        this.setChannelLocator(null);
        this.setClarity(" ");
        this.setDistance(dv);
        this.setId(0L);
        this.setMagType(null);
        this.setMagtypeDic(null);
        this.setMagVal(dv);
        this.setPeriod(dv);
        this.setPhaseName(null);
        this.setPhaseTime(null);
        this.setPhaseTimeFrac(0);
        this.setPhaseType(null);
        this.setRecType(null);
        this.setResi(dv);
        this.setSp(dv);
        this.setWeight(0);
        this.setWsign(" ");
    }

    public Pick getPick() {
        return this.pick;
    }

    public void setPick(Pick pick) {
        this.pick = pick;
    }
}

