/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.StationAmplitude;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="Station_magnitude")
public class StationMagnitude
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id", length=80)
    private String id;
    @Embedded
    private ChannelLocator channelLocator;
    @Column(name="Magnitude_type", length=16)
    private String magnitudeType;
    @Column(name="Magnitude_error")
    private Float magnitudeError;
    @Column(name="Method_id", length=16)
    private String methodId;
    @Column(name="Create_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createTime;
    @Column(name="Create_time_frac")
    private int createTimeFrac;
    @ManyToOne
    @JoinColumn(name="Catalog_id", nullable=true)
    private Catalog catalog;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="Station_amplitude_id", nullable=true)
    private StationAmplitude stationAmplitude;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMagnitudeType() {
        return this.magnitudeType;
    }

    public void setMagnitudeType(String magnitudeType) {
        this.magnitudeType = magnitudeType;
    }

    public Float getMagnitudeError() {
        return this.magnitudeError;
    }

    public void setMagnitudeError(Float magnitudeError) {
        this.magnitudeError = magnitudeError;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public void setMethodId(String methodId) {
        this.methodId = methodId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public int getCreateTimeFrac() {
        return this.createTimeFrac;
    }

    public void setCreateTimeFrac(int createTimeFrac) {
        this.createTimeFrac = createTimeFrac;
    }

    public StationAmplitude getStationAmplitude() {
        return this.stationAmplitude;
    }

    public void setStationAmplitude(StationAmplitude stationAmplitude) {
        this.stationAmplitude = stationAmplitude;
    }

    public static String buildId(StationMagnitude sm) {
        return String.valueOf(sm.getCatalog().getId()) + "#staMag." + sm.magnitudeType + "." + sm.channelLocator;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }
}

