/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity;

import cn.org.gddsn.jopens.entity.LostWaveform;
import cn.org.gddsn.jopens.service.LostWaveformServiceDAO;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.springframework.test.jpa.AbstractJpaTests;

public class TestLostServiceDAO
extends AbstractJpaTests {
    private LostWaveformServiceDAO lostWaveformServiceDAO = null;
    private double firstIdLost = -1.0;

    public void setEmployeeService(LostWaveformServiceDAO lostServiceDAO) {
        this.lostWaveformServiceDAO = lostServiceDAO;
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/cn/org/gddsn/jopens/service/jopens-spring.xml"};
    }

    protected void onSetUpInTransaction() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        LostWaveform lost1 = new LostWaveform(1L, "GD", "SHT", "00", "BHZ", new Date(sdf.parse("2006-01-01 00:00:00").getTime()), 0, 3.02f);
        LostWaveform lost2 = new LostWaveform(2L, "GD", "SHT", "00", "BHZ", new Date(sdf.parse("2006-01-01 10:00:00").getTime()), 0, 40.0f);
        LostWaveform lost3 = new LostWaveform(3L, "GD", "SHT", "00", "BHZ", new Date(sdf.parse("2006-01-02 09:10:10").getTime()), 0, 40.0f);
        LostWaveform lost4 = new LostWaveform(4L, "GD", "MEZ", "00", "SHZ", new Date(sdf.parse("2006-02-02 10:00:100").getTime()), 0, 40.5f);
        this.lostWaveformServiceDAO.save(lost1);
        this.lostWaveformServiceDAO.save(lost2);
        this.lostWaveformServiceDAO.save(lost3);
        this.lostWaveformServiceDAO.save(lost4);
        this.firstIdLost = lost1.getDuraSecs();
    }

    public void testFindById() {
        LostWaveform emp = this.lostWaveformServiceDAO.findById(1L);
        TestLostServiceDAO.assertNotNull((Object)emp);
        TestLostServiceDAO.assertEquals((Object)this.firstIdLost, (Object)Float.valueOf(emp.getDuraSecs()));
    }
}

