/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@MappedSuperclass
public class Blockette
implements Serializable {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(Blockette.class);
    public static final String SEED_FMT = "%1$tY,%1$tj,%1$tT.%2$04d~";
    private static final String SEED_TIME_FMT = "yyyy,DDD,HH:mm:ss";
    private static final DecimalFormat FOUR = new DecimalFormat("0000");
    @Transient
    protected String body = null;
    @Transient
    private int from = 7;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    protected int type;
    protected int blocketteLength;

    public int getType() {
        return this.type;
    }

    public int getBlocketteLength() {
        return this.blocketteLength;
    }

    public void setBlocketteLength(int blocketteLength) {
        this.blocketteLength = blocketteLength;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static String toSeedTime(Timestamp d) {
        SimpleDateFormat SEED_TIME = new SimpleDateFormat(SEED_TIME_FMT);
        SEED_TIME.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.valueOf(SEED_TIME.format(d)) + "." + FOUR.format(d.getNanos() / 100000);
    }

    public static Timestamp toTimestamp(String seedTime) {
        Timestamp stamp = null;
        if (seedTime == null || seedTime.length() == 0) {
            return null;
        }
        if (seedTime.length() > SEED_TIME_FMT.length()) {
            try {
                SimpleDateFormat SEED_TIME = new SimpleDateFormat(SEED_TIME_FMT);
                SEED_TIME.setTimeZone(TimeZone.getTimeZone("UTC"));
                stamp = new Timestamp(SEED_TIME.parse(seedTime.substring(0, 17)).getTime());
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), ex);
            }
            stamp.setNanos(Blockette.parseInt(seedTime.substring(18, 22)) * 100000);
            return stamp;
        }
        try {
            SimpleDateFormat SEED_TIME = new SimpleDateFormat(SEED_TIME_FMT.substring(0, seedTime.length()));
            SEED_TIME.setTimeZone(TimeZone.getTimeZone("UTC"));
            stamp = new Timestamp(SEED_TIME.parse(seedTime).getTime());
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return stamp;
    }

    public static void formatSeedTime(Formatter fmt, Timestamp timestamp) {
        Blockette.formatSeedTime(fmt, timestamp, true);
    }

    public static void formatSeedTime(Formatter fmt, Timestamp timestamp, boolean fraction) {
        if (timestamp == null) {
            fmt.format("~", new Object[0]);
        } else {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.setTime(timestamp);
            if (fraction) {
                fmt.format(SEED_FMT, cal, timestamp.getNanos() / 100000);
            } else {
                fmt.format(String.valueOf(SEED_FMT.substring(0, 17)) + "~", cal);
            }
        }
    }

    public static String removeTilde(String v) {
        int index = v.indexOf(126);
        return v.substring(0, index);
    }

    protected String getNextFixedField(int width) {
        if (this.body.length() < this.from + width) {
            throw new IllegalArgumentException("body=" + this.body + ", length is short");
        }
        String field = this.body.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    protected String getNextVariableField() {
        int index = this.body.indexOf(126, this.from);
        String field = this.body.substring(this.from, index);
        this.from = index + 1;
        return field;
    }

    public static Blockette parse(String buf, int from) {
        Blockette header = new Blockette();
        header.type = Blockette.parseInt(buf.substring(from, from + 3));
        header.blocketteLength = Blockette.parseInt(buf.substring(from + 3, from + 7));
        header.body = buf.substring(from, from + header.blocketteLength);
        if (logger.isDebugEnabled()) {
            logger.debug("Got Blockette: " + header.toString());
        }
        return header;
    }

    public void parse(Blockette block, Abbreviation abbr) {
        this.type = block.type;
        this.blocketteLength = block.blocketteLength;
        this.body = block.body;
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$03d%2$04d", this.type, this.blocketteLength);
        return sb.substring(0);
    }

    public void fixupBlocketteLength() {
        this.blocketteLength = this.toBlockette().length();
    }

    public String toString() {
        return this.toBlockette();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public static double parseDouble(String str) {
        if (str.startsWith("-")) {
            return -Double.parseDouble(str.replace('-', ' ').trim());
        }
        return Double.parseDouble(str.replace('+', ' ').trim());
    }

    public static int parseInt(String str) {
        return Integer.parseInt(str.trim());
    }
}

