/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;

@Entity
public class Blockette010
extends Blockette {
    private static final long serialVersionUID = -2178960942996112953L;
    @Column(length=4)
    private String version = "02.3";
    private int logicalRecordLength = 12;
    private Timestamp startTime;
    private Timestamp endTime;
    private Timestamp volumeTime;
    @Column(length=80)
    private String organization = "GDDSN";
    @Column(length=80)
    private String label = "GDDSN 2007 001";

    public Blockette010() {
        this.type = 10;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLogicalRecordLength() {
        return this.logicalRecordLength;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getVersion() {
        return this.version;
    }

    public Timestamp getVolumeTime() {
        return this.volumeTime;
    }

    public void setVolumeTime(Timestamp volumeTime) {
        this.volumeTime = volumeTime;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setLogicalRecordLength(int logicalRecordLength) {
        this.logicalRecordLength = logicalRecordLength;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(Timestamp beginningTime) {
        this.startTime = beginningTime;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.version = block.getNextFixedField(4);
        this.logicalRecordLength = Blockette010.parseInt(block.getNextFixedField(2));
        this.startTime = Blockette.toTimestamp(block.getNextVariableField());
        this.endTime = Blockette.toTimestamp(block.getNextVariableField());
        String tmp = block.getNextVariableField();
        if (tmp.length() == 21) {
            tmp = String.valueOf(tmp) + "0";
        }
        this.volumeTime = Blockette.toTimestamp(tmp);
        this.organization = block.getNextVariableField();
        this.label = block.getNextVariableField();
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$4s%2$02d", this.version, this.logicalRecordLength);
        Blockette010.formatSeedTime(fmt, this.startTime);
        Blockette010.formatSeedTime(fmt, this.endTime);
        Blockette010.formatSeedTime(fmt, this.volumeTime);
        fmt.format("%1$s~%2$s~", this.organization, this.label);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

