/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Pair;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette011
extends Blockette {
    private static final long serialVersionUID = 3059709357784514532L;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b011_id", nullable=false)
    private List<Pair> pairs = new ArrayList<Pair>();

    public Blockette011() {
        this.type = 11;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        int numberOfStation = Blockette011.parseInt(block.getNextFixedField(3));
        this.pairs = new ArrayList<Pair>(numberOfStation);
        int i = 0;
        while (i < numberOfStation) {
            Pair pair = new Pair();
            pair.setStation(block.getNextFixedField(5).trim());
            pair.setSequence(Blockette011.parseInt(block.getNextFixedField(6)));
            this.pairs.add(pair);
            ++i;
        }
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$03d", this.pairs.size());
        for (Pair pair : this.pairs) {
            fmt.format("%1$-5s%2$06d", pair.getStation(), pair.getSequence());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public List<Pair> getPairs() {
        return this.pairs;
    }

    public void setPairs(List<Pair> pairs) {
        this.pairs = pairs;
    }
}

