/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Span;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette012
extends Blockette {
    private static final long serialVersionUID = 7738052540853994711L;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b012_id", nullable=false)
    private List<Span> spans = new ArrayList<Span>();

    public Blockette012() {
        this.type = 12;
    }

    public void merge(Blockette012 b012) {
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    public void setSpans(List<Span> spans) {
        this.spans = spans;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        int numberOfSpans = Blockette012.parseInt(block.getNextFixedField(4));
        this.spans = new ArrayList<Span>(numberOfSpans);
        int i = 0;
        while (i < numberOfSpans) {
            Span span = new Span();
            span.setBeginingOfSpan(Blockette.toTimestamp(block.getNextVariableField()));
            span.setEndOfSpan(Blockette.toTimestamp(block.getNextVariableField()));
            span.setSequence(Blockette012.parseInt(block.getNextFixedField(6)));
            this.spans.add(span);
            ++i;
        }
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$04d", this.spans.size());
        for (Span span : this.spans) {
            Blockette012.formatSeedTime(fmt, span.getBeginingOfSpan());
            Blockette012.formatSeedTime(fmt, span.getEndOfSpan());
            fmt.format("%1$06d", span.getSequence());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

