/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Blockette034
extends Blockette {
    private int lookupCode;
    @Column(length=20)
    private String unitName;
    @Column(length=50)
    private String unitDescription;
    @ManyToOne
    @JoinColumn(name="abbr_id", nullable=true)
    private Abbreviation abbreviation;

    public Blockette034() {
        this.type = 34;
    }

    public int getLookupCode() {
        return this.lookupCode;
    }

    public String getUnitDescription() {
        return this.unitDescription;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setLookupCode(int lookupCode) {
        this.lookupCode = lookupCode;
    }

    public void setUnitDescription(String unitDescription) {
        this.unitDescription = unitDescription;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.lookupCode = Blockette034.parseInt(block.getNextFixedField(3));
        this.unitName = block.getNextVariableField();
        this.unitDescription = block.getNextVariableField();
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$03d%2$s~%3$s~", this.lookupCode, this.unitName, this.unitDescription);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Abbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String toString() {
        return this.unitName;
    }
}

