/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette033;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

@Entity
public class Blockette050
extends Blockette {
    private static final long serialVersionUID = 1L;
    @Column(length=5)
    private String station;
    private double latitude;
    private double longitude;
    private double elevation;
    private int numberOfChannels;
    private int numberOfcomment;
    @Column(length=60)
    private String siteName;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="b033_id", nullable=true)
    private Blockette033 networkIdentifierCode;
    @Column(length=4)
    private String wordOrder32 = "3210";
    @Column(length=2)
    private String wordOrder16 = "10";
    private Timestamp startTime;
    private Timestamp endTime;
    @Column(length=1)
    private char updateFlag = (char)78;
    @Column(length=2)
    private String networkCode;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="NetworkInfo_id", nullable=true)
    private NetworkInfo networkInfo;

    public Blockette050() {
        this.type = 50;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public Blockette033 getNetworkIdentifierCode() {
        return this.networkIdentifierCode;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public int getNumberOfcomment() {
        return this.numberOfcomment;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public String getStation() {
        return this.station;
    }

    public char getUpdateFlag() {
        return this.updateFlag;
    }

    public String getWordOrder16() {
        return this.wordOrder16;
    }

    public String getWordOrder32() {
        return this.wordOrder32;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public void setNetworkIdentifierCode(Blockette033 networkIdentifierCode) {
        this.networkIdentifierCode = networkIdentifierCode;
    }

    public void setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    public void setNumberOfcomment(int numberOfcomment) {
        this.numberOfcomment = numberOfcomment;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public void setUpdateFlag(char updateFlag) {
        this.updateFlag = updateFlag;
    }

    public void setWordOrder16(String wordOrder16) {
        this.wordOrder16 = wordOrder16;
    }

    public void setWordOrder32(String wordOrder32) {
        this.wordOrder32 = wordOrder32;
    }

    public NetworkInfo getNetworkInfo() {
        return this.networkInfo;
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        this.networkInfo = networkInfo;
    }

    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.station = block.getNextFixedField(5).trim();
        this.latitude = Blockette050.parseDouble(block.getNextFixedField(10));
        this.longitude = Blockette050.parseDouble(block.getNextFixedField(11));
        this.elevation = Blockette050.parseDouble(block.getNextFixedField(7));
        this.numberOfChannels = Blockette050.parseInt(block.getNextFixedField(4));
        this.numberOfcomment = Blockette050.parseInt(block.getNextFixedField(3));
        this.siteName = block.getNextVariableField();
        int lookup = Blockette050.parseInt(block.getNextFixedField(3));
        this.networkIdentifierCode = abbr.findBlockette033ByIndex(lookup);
        if (this.networkIdentifierCode == null) {
            logger.info("networkIdentifierCode is " + lookup + ", but could not found in Abbr: " + block.body);
        }
        this.wordOrder32 = block.getNextFixedField(4);
        this.wordOrder16 = block.getNextFixedField(2);
        this.startTime = Blockette.toTimestamp(block.getNextVariableField());
        this.endTime = Blockette.toTimestamp(block.getNextVariableField());
        this.updateFlag = block.getNextFixedField(1).charAt(0);
        this.networkCode = block.getNextFixedField(2);
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$-5s%2$+010.6f%3$+011.6f%4$+07.1f", this.station, this.latitude, this.longitude, this.elevation);
        fmt.format("%1$04d%2$03d%3$s~", this.numberOfChannels, this.numberOfcomment, this.siteName);
        fmt.format("%1$03d%2$4s%3$2s", this.networkIdentifierCode != null ? this.networkIdentifierCode.getLookupCode() : 0, this.wordOrder32, this.wordOrder16);
        Blockette.formatSeedTime(fmt, this.startTime, false);
        Blockette.formatSeedTime(fmt, this.endTime, false);
        fmt.format("%1$c%2$2s", Character.valueOf(this.updateFlag), this.networkCode);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

