/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette030;
import cn.org.gddsn.jopens.entity.seed.Blockette033;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import org.apache.log4j.Logger;

@Entity
public class Blockette052
extends Blockette {
    static Logger logger = Logger.getLogger(Blockette052.class);
    @Column(length=2)
    private String location;
    @Column(length=3)
    private String channel;
    @Column(length=4)
    private String subChannel = "    ";
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="b033_id", nullable=true)
    private Blockette033 instrument;
    @Column(length=30)
    private String optionalComment = "";
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="unitOfSignalResponse_id", nullable=true)
    private Blockette034 unitOfSignalResponse;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="unitOfCalibrationInput_id", nullable=true)
    private Blockette034 unitOfCalibrationInput;
    private double latitude;
    private double longitude;
    private double elevation;
    private double localDepth;
    private double azimuth;
    private double dip;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="b030_id", nullable=true)
    private Blockette030 dataFormat;
    private int dataRecordLength;
    private double sampleRate;
    private double maxClockDrift;
    private int numberOfcomments;
    @Column(length=26)
    private String channelFlag;
    private Timestamp startTime;
    private Timestamp endTime;
    @Column(length=1)
    private char updateFlag = (char)78;

    public Blockette052() {
        this.type = 52;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getChannelFlag() {
        return this.channelFlag;
    }

    public Blockette030 getDataFormat() {
        return this.dataFormat;
    }

    public int getDataRecordLength() {
        return this.dataRecordLength;
    }

    public double getDip() {
        return this.dip;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLocalDepth() {
        return this.localDepth;
    }

    public String getLocation() {
        return this.location;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getMaxClockDrift() {
        return this.maxClockDrift;
    }

    public int getNumberOfcomments() {
        return this.numberOfcomments;
    }

    public String getOptionalComment() {
        return this.optionalComment;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public String getSubChannel() {
        return this.subChannel;
    }

    public Blockette034 getUnitOfCalibrationInput() {
        return this.unitOfCalibrationInput;
    }

    public Blockette034 getUnitOfSignalResponse() {
        return this.unitOfSignalResponse;
    }

    public char getUpdateFlag() {
        return this.updateFlag;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setChannelFlag(String channelFlag) {
        this.channelFlag = channelFlag;
    }

    public void setDataFormat(Blockette030 dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setDataRecordLength(int dataRecordLength) {
        this.dataRecordLength = dataRecordLength;
    }

    public void setDip(double dip) {
        this.dip = dip;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public void setEndTime(Timestamp endDate) {
        this.endTime = endDate;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLocalDepth(double localDepth) {
        this.localDepth = localDepth;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setMaxClockDrift(double maxClockDrift) {
        this.maxClockDrift = maxClockDrift;
    }

    public void setNumberOfcomments(int numberOfcomments) {
        this.numberOfcomments = numberOfcomments;
    }

    public void setOptionalComment(String optionalComment) {
        this.optionalComment = optionalComment;
    }

    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setStartTime(Timestamp startDate) {
        this.startTime = startDate;
    }

    public void setSubChannel(String subChannel) {
        this.subChannel = subChannel;
    }

    public void setUnitOfCalibrationInput(Blockette034 unitOfCalibrationInput) {
        this.unitOfCalibrationInput = unitOfCalibrationInput;
    }

    public void setUnitOfSignalResponse(Blockette034 unitOfSignalResponse) {
        this.unitOfSignalResponse = unitOfSignalResponse;
    }

    public void setUpdateFlag(char updateFlag) {
        this.updateFlag = updateFlag;
    }

    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.location = block.getNextFixedField(2);
        this.channel = block.getNextFixedField(3);
        this.subChannel = block.getNextFixedField(4);
        int lookupCode = Blockette052.parseInt(block.getNextFixedField(3));
        this.instrument = abbr.findBlockette033ByIndex(lookupCode);
        this.optionalComment = block.getNextVariableField();
        int unitOfSignalResponse_code = Blockette052.parseInt(block.getNextFixedField(3));
        this.unitOfSignalResponse = abbr.findBlockette034ByIndex(unitOfSignalResponse_code);
        int unitOfCalibrationInput_code = Blockette052.parseInt(block.getNextFixedField(3));
        this.unitOfCalibrationInput = abbr.findBlockette034ByIndex(unitOfCalibrationInput_code);
        if (this.unitOfCalibrationInput == null) {
            logger.info("unitOfCalibrationInput_code is " + unitOfCalibrationInput_code + ", but could not found in Abbr: " + block.body);
        }
        this.latitude = Blockette052.parseDouble(block.getNextFixedField(10));
        this.longitude = Blockette052.parseDouble(block.getNextFixedField(11));
        this.elevation = Blockette052.parseDouble(block.getNextFixedField(7));
        this.localDepth = Blockette052.parseDouble(block.getNextFixedField(5));
        this.azimuth = Blockette052.parseDouble(block.getNextFixedField(5));
        this.dip = Blockette052.parseDouble(block.getNextFixedField(5));
        int dataFormat_code = Blockette052.parseInt(block.getNextFixedField(4));
        this.dataFormat = abbr.findBlockette030ByIndex(dataFormat_code);
        this.dataRecordLength = Blockette052.parseInt(block.getNextFixedField(2));
        this.sampleRate = Double.parseDouble(block.getNextFixedField(10));
        this.maxClockDrift = Double.parseDouble(block.getNextFixedField(10));
        this.numberOfcomments = Blockette052.parseInt(block.getNextFixedField(4));
        this.channelFlag = block.getNextVariableField();
        this.startTime = Blockette.toTimestamp(block.getNextVariableField());
        this.endTime = Blockette.toTimestamp(block.getNextVariableField());
        this.updateFlag = block.getNextFixedField(1).charAt(0);
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$2s%2$3s%3$-4s%4$03d", this.location, this.channel, this.subChannel, this.instrument != null ? this.instrument.getLookupCode() : 0);
        fmt.format("%1$s~%2$03d%3$03d", this.optionalComment, this.unitOfSignalResponse != null ? this.unitOfSignalResponse.getLookupCode() : 0, this.unitOfCalibrationInput != null ? this.unitOfCalibrationInput.getLookupCode() : 0);
        fmt.format("%1$+010.6f%2$+011.6f%3$+07.1f%4$05.1f", this.latitude, this.longitude, this.elevation, this.localDepth);
        fmt.format("%1$05.1f%2$+05.1f%3$04d%4$02d", this.azimuth, this.dip, this.dataFormat.getDataFormat(), this.dataRecordLength);
        fmt.format("%1$10.4E%2$10.4E%3$04d%4$s~", this.sampleRate, this.maxClockDrift, this.numberOfcomments, this.channelFlag);
        Blockette.formatSeedTime(fmt, this.startTime, false);
        Blockette.formatSeedTime(fmt, this.endTime, false);
        fmt.format("%1$c", Character.valueOf(this.updateFlag));
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Blockette033 getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Blockette033 instrument) {
        this.instrument = instrument;
    }
}

