/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Coeff;
import cn.org.gddsn.jopens.entity.seed.CoeffBlob;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette054
extends Blockette {
    private static final long serialVersionUID = -5761778760561985729L;
    @Column(length=1)
    private char responseType = (char)68;
    private int stageSequence;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalInputUnit_id", nullable=false)
    private Blockette034 signalInputUnit;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalOutputUnit_id", nullable=false)
    private Blockette034 signalOutputUnit;
    @Transient
    private List<Coeff> numerators = new ArrayList<Coeff>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="num_id", nullable=false)
    private CoeffBlob numBlob = new CoeffBlob();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="den_id", nullable=false)
    private CoeffBlob denBlob = new CoeffBlob();
    @Transient
    private List<Coeff> denominators = new ArrayList<Coeff>();

    public Blockette054() {
        this.type = 54;
    }

    public void merge(Blockette054 b054) {
        this.getNumerators().addAll(b054.getNumerators());
        StringBuffer buf = new StringBuffer(1024);
        for (Coeff ce : this.numerators) {
            buf.append(String.valueOf(ce.getCoeff()) + " ");
            buf.append(String.valueOf(ce.getError()) + "\n");
        }
        this.numBlob = new CoeffBlob();
        this.numBlob.setCoeff(buf.substring(0));
        this.getDenominators().addAll(b054.getDenominators());
        buf = new StringBuffer(1024);
        for (Coeff ce : this.denominators) {
            buf.append(String.valueOf(ce.getCoeff()) + " ");
            buf.append(String.valueOf(ce.getError()) + "\n");
        }
        this.denBlob = new CoeffBlob();
        this.denBlob.setCoeff(buf.substring(0));
    }

    public char getResponseType() {
        return this.responseType;
    }

    public Blockette034 getSignalInputUnit() {
        return this.signalInputUnit;
    }

    public Blockette034 getSignalOutputUnit() {
        return this.signalOutputUnit;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public List<Coeff> getDenominators() {
        if (this.denominators.size() == 0) {
            this.initDenBlob();
        }
        return this.denominators;
    }

    public List<Coeff> getNumerators() {
        if (this.numerators.size() == 0) {
            this.initNumBlob();
        }
        return this.numerators;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    public void setSignalOutputUnit(Blockette034 signalOutputUnit) {
        this.signalOutputUnit = signalOutputUnit;
    }

    public void setSignalInputUnit(Blockette034 signalInputUnit) {
        this.signalInputUnit = signalInputUnit;
    }

    public void setResponseType(char responseType) {
        this.responseType = responseType;
    }

    public void setDenominators(List<Coeff> denominators) {
        this.denominators = denominators;
        StringBuffer buf = new StringBuffer(1024);
        for (Coeff ce : denominators) {
            buf.append(String.valueOf(ce.getCoeff()) + " ");
            buf.append(String.valueOf(ce.getError()) + "\n");
        }
        if (this.denBlob == null) {
            this.denBlob = new CoeffBlob();
        }
        this.denBlob.setCoeff(buf.substring(0));
    }

    public void setNumerators(List<Coeff> numerators) {
        this.numerators = numerators;
        StringBuffer buf = new StringBuffer(1024);
        for (Coeff ce : numerators) {
            buf.append(String.valueOf(ce.getCoeff()) + " ");
            buf.append(String.valueOf(ce.getError()) + "\n");
        }
        if (this.numBlob == null) {
            this.numBlob = new CoeffBlob();
        }
        this.numBlob.setCoeff(buf.substring(0));
    }

    @Override
    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.responseType = block.getNextFixedField(1).charAt(0);
        this.stageSequence = Blockette054.parseInt(block.getNextFixedField(2));
        int signalInputUnit_code = Blockette054.parseInt(block.getNextFixedField(3));
        int signalOutputUnit_code = Blockette054.parseInt(block.getNextFixedField(3));
        this.signalInputUnit = abbr.findBlockette034ByIndex(signalInputUnit_code);
        this.signalOutputUnit = abbr.findBlockette034ByIndex(signalOutputUnit_code);
        int numberOfNumerators = Blockette054.parseInt(block.getNextFixedField(4));
        ArrayList<Coeff> numerators1 = new ArrayList<Coeff>();
        int i = 0;
        while (i < numberOfNumerators) {
            Coeff n = new Coeff();
            n.setCoeff(Double.parseDouble(block.getNextFixedField(12)));
            n.setError(Double.parseDouble(block.getNextFixedField(12)));
            numerators1.add(n);
            ++i;
        }
        this.setNumerators(numerators1);
        int numberOfPoles = Blockette054.parseInt(block.getNextFixedField(4));
        ArrayList<Coeff> denominators1 = new ArrayList<Coeff>();
        int i2 = 0;
        while (i2 < numberOfPoles) {
            Coeff d = new Coeff();
            d.setCoeff(Double.parseDouble(block.getNextFixedField(12)));
            d.setError(Double.parseDouble(block.getNextFixedField(12)));
            denominators1.add(d);
            ++i2;
        }
        this.setDenominators(denominators1);
    }

    @Override
    public String toBlockette() {
        Coeff c;
        int k;
        this.getDenominators();
        this.getNumerators();
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        int mp = 415;
        int ntotal = this.numerators.size() + this.denominators.size();
        if (ntotal < mp) {
            return this.toBlockette0();
        }
        ntotal = this.numerators.size();
        int nn = ntotal / mp;
        if (ntotal % mp != 0) {
            ++nn;
        }
        int n = 0;
        int bl = 0;
        int i = 0;
        while (i < nn) {
            bl = i != nn - 1 ? mp : ntotal - (nn - 1) * mp;
            fmt.format("%1$03d%2$04d", this.type, bl * 2 * 12 + 24);
            fmt.format("%1$c%2$02d%3$03d%4$03d", Character.valueOf(this.responseType), this.stageSequence, this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
            fmt.format("%1$04d", bl);
            k = 0;
            while (k < bl) {
                c = this.numerators.get(n++);
                fmt.format("%1$ 12.5E%2$ 12.5E", c.getCoeff(), c.getError());
                ++k;
            }
            fmt.format("%1$04d", 0);
            ++i;
        }
        ntotal = this.denominators.size();
        nn = ntotal / mp;
        if (ntotal % mp != 0) {
            ++nn;
        }
        n = 0;
        i = 0;
        while (i < nn) {
            bl = i != nn - 1 ? mp : ntotal - (nn - 1) * mp;
            fmt.format("%1$03d%2$04d", this.type, bl * 2 * 12 + 24);
            fmt.format("%1$c%2$02d%3$03d%4$03d", Character.valueOf(this.responseType), this.stageSequence, this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
            fmt.format("%1$04d", 0);
            fmt.format("%1$04d", bl);
            k = 0;
            while (k < bl) {
                c = this.denominators.get(n++);
                fmt.format("%1$ 12.5E%2$ 12.5E", c.getCoeff(), c.getError());
                ++k;
            }
            ++i;
        }
        return sb.substring(0);
    }

    private String toBlockette0() {
        this.getDenominators();
        this.getNumerators();
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$c%2$02d%3$03d%4$03d", Character.valueOf(this.responseType), this.stageSequence, this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
        fmt.format("%1$04d", this.numerators.size());
        for (Coeff n : this.numerators) {
            fmt.format("%1$ 12.5E%2$ 12.5E", n.getCoeff(), n.getError());
        }
        fmt.format("%1$04d", this.denominators.size());
        for (Coeff d : this.denominators) {
            fmt.format("%1$ 12.5E%2$ 12.5E", d.getCoeff(), d.getError());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public CoeffBlob getDenBlob() {
        return this.denBlob;
    }

    public void setDenBlob(CoeffBlob denBlob) {
        this.denBlob = denBlob;
        this.initDenBlob();
    }

    private void initDenBlob() {
        String line = this.denBlob.getCoeff();
        if (line == null) {
            logger.warn("coluld not found den data for Blockette054 id=" + this.getId());
            return;
        }
        StringTokenizer st = new StringTokenizer(line);
        int n = st.countTokens() / 2;
        this.denominators.clear();
        int i = 0;
        while (i < n) {
            Coeff ce = new Coeff();
            ce.setCoeff(Double.parseDouble(st.nextToken()));
            ce.setError(Double.parseDouble(st.nextToken()));
            this.denominators.add(ce);
            ++i;
        }
    }

    public CoeffBlob getNumBlob() {
        return this.numBlob;
    }

    public void setNumBlob(CoeffBlob numBlob) {
        this.numBlob = numBlob;
        this.initNumBlob();
    }

    private void initNumBlob() {
        String line = this.numBlob.getCoeff();
        if (line == null) {
            logger.warn("coluld not found num data for Blockette054 id=" + this.getId());
            return;
        }
        StringTokenizer st = new StringTokenizer(line);
        int n = st.countTokens() / 2;
        this.numerators.clear();
        int i = 0;
        while (i < n) {
            Coeff ce = new Coeff();
            ce.setCoeff(Double.parseDouble(st.nextToken()));
            ce.setError(Double.parseDouble(st.nextToken()));
            this.numerators.add(ce);
            ++i;
        }
    }
}

