/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Entity;

@Entity
public class Blockette057
extends Blockette {
    private int stageSequence;
    private double inputSampleRate;
    private int decimationFactor;
    private int decimationOffset;
    private double estimatedDelay;
    private double correctionApplied;

    public Blockette057() {
        this.type = 57;
    }

    public double getCorrectionApplied() {
        return this.correctionApplied;
    }

    public int getDecimationFactor() {
        return this.decimationFactor;
    }

    public int getDecimationOffset() {
        return this.decimationOffset;
    }

    public double getEstimatedDelay() {
        return this.estimatedDelay;
    }

    public double getInputSampleRate() {
        return this.inputSampleRate;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public void setCorrectionApplied(double correctionApplied) {
        this.correctionApplied = correctionApplied;
    }

    public void setDecimationFactor(int decimationFactor) {
        this.decimationFactor = decimationFactor;
    }

    public void setDecimationOffset(int decimationOffset) {
        this.decimationOffset = decimationOffset;
    }

    public void setEstimatedDelay(double estimatedDelay) {
        this.estimatedDelay = estimatedDelay;
    }

    public void setInputSampleRate(double inputSampleRate) {
        this.inputSampleRate = inputSampleRate;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.stageSequence = Blockette057.parseInt(block.getNextFixedField(2));
        this.inputSampleRate = Double.parseDouble(block.getNextFixedField(10));
        this.decimationFactor = Blockette057.parseInt(block.getNextFixedField(5));
        this.decimationOffset = Blockette057.parseInt(block.getNextFixedField(5));
        this.estimatedDelay = Double.parseDouble(block.getNextFixedField(11));
        this.correctionApplied = Double.parseDouble(block.getNextFixedField(11));
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$02d%2$10.4E%3$05d%4$05d", this.stageSequence, this.inputSampleRate, this.decimationFactor, this.decimationOffset);
        fmt.format("%1$11.4E%2$11.4E", this.estimatedDelay, this.correctionApplied);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

