/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Coeff;
import cn.org.gddsn.jopens.entity.seed.CoeffBlob;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette061
extends Blockette {
    @Column(length=1)
    private char responseType = (char)68;
    private int stageSequence;
    private String name;
    private char symmetryCode;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="signalInputUnit_id", nullable=false)
    private Blockette034 signalInputUnit;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="signalOutputUnit_id", nullable=false)
    private Blockette034 signalOutputUnit;
    @Transient
    private List<Coeff> firCoeff = new ArrayList<Coeff>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="num_id", nullable=false)
    private CoeffBlob firCoeffBlob = new CoeffBlob();

    public Blockette061() {
        this.type = 61;
    }

    public char getResponseType() {
        return this.responseType;
    }

    public Blockette034 getSignalInputUnit() {
        return this.signalInputUnit;
    }

    public Blockette034 getSignalOutputUnit() {
        return this.signalOutputUnit;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    public void setSignalOutputUnit(Blockette034 signalOutputUnit) {
        this.signalOutputUnit = signalOutputUnit;
    }

    public void setSignalInputUnit(Blockette034 signalInputUnit) {
        this.signalInputUnit = signalInputUnit;
    }

    public void setResponseType(char responseType) {
        this.responseType = responseType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public char getSymmetryCode() {
        return this.symmetryCode;
    }

    public void setSymmetryCode(char symmetryCode) {
        this.symmetryCode = symmetryCode;
    }

    public void setFirCoeff(List<Coeff> firCoeff) {
        this.firCoeff = firCoeff;
        StringBuffer buf = new StringBuffer(1024);
        for (Coeff ce : firCoeff) {
            buf.append(String.valueOf(ce.getCoeff()) + "\n");
        }
        if (this.firCoeffBlob == null) {
            this.firCoeffBlob = new CoeffBlob();
        }
        this.firCoeffBlob.setCoeff(buf.substring(0));
    }

    public List<Coeff> getFirCoeff() {
        if (this.firCoeff.size() == 0) {
            this.initFirCoeffBlob();
        }
        return this.firCoeff;
    }

    public CoeffBlob getFirCoeffBlob() {
        return this.firCoeffBlob;
    }

    public void setFirCoeffBlob(CoeffBlob firCoeffBlob) {
        this.firCoeffBlob = firCoeffBlob;
        this.initFirCoeffBlob();
    }

    private void initFirCoeffBlob() {
        StringTokenizer st = new StringTokenizer(this.firCoeffBlob.getCoeff());
        int n = st.countTokens();
        this.firCoeff.clear();
        int i = 0;
        while (i < n) {
            Coeff ce = new Coeff();
            ce.setCoeff(Double.parseDouble(st.nextToken()));
            this.firCoeff.add(ce);
            ++i;
        }
    }

    @Override
    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.stageSequence = Blockette061.parseInt(block.getNextFixedField(2));
        this.name = block.getNextVariableField();
        this.symmetryCode = block.getNextFixedField(1).charAt(0);
        int signalInputUnit_code = Blockette061.parseInt(block.getNextFixedField(3));
        int signalOutputUnit_code = Blockette061.parseInt(block.getNextFixedField(3));
        this.signalInputUnit = abbr.findBlockette034ByIndex(signalInputUnit_code);
        this.signalOutputUnit = abbr.findBlockette034ByIndex(signalOutputUnit_code);
        int numberOfNumerators = Blockette061.parseInt(block.getNextFixedField(4));
        ArrayList<Coeff> firCoeff1 = new ArrayList<Coeff>();
        int i = 0;
        while (i < numberOfNumerators) {
            Coeff n = new Coeff();
            n.setCoeff(Double.parseDouble(block.getNextFixedField(14)));
            firCoeff1.add(n);
            ++i;
        }
        this.setFirCoeff(firCoeff1);
    }

    @Override
    public String toBlockette() {
        this.getFirCoeff();
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$02d%2$s~%3$c%4$03d%5$03d", this.stageSequence, this.name, Character.valueOf(this.symmetryCode), this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
        fmt.format("%1$04d", this.firCoeff.size());
        for (Coeff n : this.firCoeff) {
            fmt.format("%1$ 14.7E", n.getCoeff());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

