/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette032;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

@Entity
public class Blockette072
extends Blockette {
    @Column(length=5)
    private String station;
    @Column(length=2)
    private String location;
    @Column(length=3)
    private String channel;
    private Timestamp arrivalTime;
    private double amp;
    private double period;
    private double ratio;
    @Column(length=22)
    private String phaseName;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="b032_id", nullable=false)
    private Blockette032 source;
    @Column(length=2)
    private String networkCode;

    public Blockette072() {
        this.type = 72;
    }

    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.station = block.getNextFixedField(5).trim();
        this.location = block.getNextFixedField(2);
        this.channel = block.getNextFixedField(3);
        this.arrivalTime = Blockette.toTimestamp(block.getNextVariableField());
        this.amp = Double.parseDouble(block.getNextFixedField(10));
        this.period = Double.parseDouble(block.getNextFixedField(10));
        this.ratio = Double.parseDouble(block.getNextFixedField(10));
        this.phaseName = block.getNextVariableField();
        int source_code = Blockette072.parseInt(block.getNextFixedField(2));
        this.source = abbr.findBlockette032ByIndex(source_code);
        this.networkCode = block.getNextFixedField(2);
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$-5s%2$2s%3$3s", this.station, this.location, this.channel);
        Blockette.formatSeedTime(fmt, this.arrivalTime);
        fmt.format("%1$10.5E%2$10.5E%3$10.5E", this.amp, this.period, this.ratio);
        fmt.format("%1$s~%2$02d%3$02s", this.phaseName, this.source != null ? this.source.getLookupCode() : 0, this.networkCode);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public double getAmp() {
        return this.amp;
    }

    public Timestamp getArrivalTime() {
        return this.arrivalTime;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public double getPeriod() {
        return this.period;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public double getRatio() {
        return this.ratio;
    }

    public Blockette032 getSource() {
        return this.source;
    }

    public String getStation() {
        return this.station;
    }

    public void setAmp(double amp) {
        this.amp = amp;
    }

    public void setArrivalTime(Timestamp arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public void setPeriod(double period) {
        this.period = period;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public void setSource(Blockette032 source) {
        this.source = source;
    }

    public void setStation(String station) {
        this.station = station;
    }
}

