/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Accelerator;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette074
extends Blockette {
    @Column(length=5)
    private String station;
    @Column(length=2)
    private String location;
    @Column(length=3)
    private String channel;
    private Timestamp startTime;
    private int firstSequence;
    private int firstSubSequence;
    private Timestamp endTime;
    private int lastSequence;
    private int lastSubSeuence;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b074_id", nullable=true)
    private List<Accelerator> accelerators = new ArrayList<Accelerator>();
    @Column(length=2)
    private String networkCode;

    public Blockette074() {
        this.type = 74;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.station = block.getNextFixedField(5).trim();
        this.location = block.getNextFixedField(2);
        this.channel = block.getNextFixedField(3);
        this.startTime = Blockette.toTimestamp(block.getNextVariableField());
        this.firstSequence = Blockette074.parseInt(block.getNextFixedField(6));
        this.firstSubSequence = Blockette074.parseInt(block.getNextFixedField(2));
        this.endTime = Blockette.toTimestamp(block.getNextVariableField());
        this.lastSequence = Blockette074.parseInt(block.getNextFixedField(6));
        this.lastSubSeuence = Blockette074.parseInt(block.getNextFixedField(2));
        int numberOfAccelerators = Blockette074.parseInt(block.getNextFixedField(3));
        this.accelerators = new ArrayList<Accelerator>();
        int i = 0;
        while (i < numberOfAccelerators) {
            Accelerator a = new Accelerator();
            a.setStartTime(Blockette.toTimestamp(block.getNextVariableField()));
            a.setSequence(Blockette074.parseInt(block.getNextFixedField(6)));
            a.setSubSequence(Blockette074.parseInt(block.getNextFixedField(2)));
            this.accelerators.add(a);
            ++i;
        }
        this.networkCode = block.getNextFixedField(2);
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$-5s%2$2s%3$3s", this.station, this.location, this.channel);
        Blockette.formatSeedTime(fmt, this.startTime);
        fmt.format("%1$06d%2$02d", this.firstSequence, this.firstSubSequence);
        Blockette.formatSeedTime(fmt, this.endTime);
        fmt.format("%1$06d%2$02d%3$03d", this.lastSequence, this.lastSubSeuence, this.accelerators.size());
        for (Accelerator a : this.accelerators) {
            Blockette.formatSeedTime(fmt, a.getStartTime());
            fmt.format("%1$06d%2$02d", a.getSequence(), a.getSubSequence());
        }
        fmt.format("%1$2s", this.networkCode);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public List<Accelerator> getAccelerators() {
        return this.accelerators;
    }

    public String getChannel() {
        return this.channel;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public int getFirstSequence() {
        return this.firstSequence;
    }

    public int getFirstSubSequence() {
        return this.firstSubSequence;
    }

    public int getLastSequence() {
        return this.lastSequence;
    }

    public int getLastSubSeuence() {
        return this.lastSubSeuence;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public String getStation() {
        return this.station;
    }

    public void setAccelerators(List<Accelerator> accelerators) {
        this.accelerators = accelerators;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setFirstSequence(int firstSequence) {
        this.firstSequence = firstSequence;
    }

    public void setFirstSubSequence(int firstSubSequence) {
        this.firstSubSequence = firstSubSequence;
    }

    public void setLastSequence(int lastSequence) {
        this.lastSequence = lastSequence;
    }

    public void setLastSubSeuence(int lastSubSeuence) {
        this.lastSubSeuence = lastSubSeuence;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void setStation(String station) {
        this.station = station;
    }
}

