/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.LogicalBlock;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class RawVolume {
    static Logger logger = Logger.getLogger(RawVolume.class);
    private InputStream in;
    private int logicalSize = 4096;
    private boolean eof = false;
    private byte[] buf;

    public void setIn(InputStream in) {
        this.in = in;
        try {
            byte[] fbuf = new byte[32];
            in.read(fbuf);
            String blkSize = new String(fbuf, 19, 2, "US-ASCII").trim();
            int exp = Integer.parseInt(blkSize);
            this.logicalSize = (int)Math.pow(2.0, exp);
            logger.info("Volume logical Size: " + this.logicalSize);
            this.buf = new byte[this.logicalSize];
            System.arraycopy(fbuf, 0, this.buf, 0, fbuf.length);
            in.read(this.buf, fbuf.length, this.logicalSize - fbuf.length);
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public int getLogicalSize() {
        return this.logicalSize;
    }

    public LogicalBlock next() {
        if (this.eof) {
            return null;
        }
        int nblock = 1;
        StringBuilder sb = new StringBuilder(this.logicalSize);
        try {
            sb.append(new String(this.buf, "US-ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        try {
            while (true) {
                if (this.in.read(this.buf) < 0) {
                    this.eof = true;
                } else if (this.buf[7] == 42) {
                    sb.append(new String(this.buf, 8, this.buf.length - 8, "US-ASCII"));
                    ++nblock;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
            return null;
        }
        return LogicalBlock.parse(sb.substring(0), nblock);
    }

    public byte[] getCurrentBuffer() {
        return this.buf;
    }
}

