/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.LogStation;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.CatalogService;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={CatalogService.class})
@Remote(value={CatalogService.class})
public class CatalogServiceBean
implements CatalogService {
    static Logger logger = Logger.getLogger(CatalogServiceBean.class);
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<Catalog> findCatalogByParams(Date startTime, Date endTime, float lonmin, float lonmax, float latmin, float latmax, float min, float max, String location, String autoFlag) {
        String statement = "select e from Catalog" + autoFlag + " e where " + "e.originTime >= :start  and e.originTime <= :end and " + "e.lon >= :lonmin  and e.lon <= :lonmax and " + "e.lat >= :latmin  and e.lat <= :latmax and " + "e.m >= :min  and e.m <= :max  and " + "e.location like :location ";
        Query query = this.em.createQuery(statement).setParameter("start", startTime, TemporalType.TIMESTAMP).setParameter("end", endTime, TemporalType.TIMESTAMP).setParameter("lonmin", (Object)Float.valueOf(lonmin)).setParameter("lonmax", (Object)Float.valueOf(lonmax)).setParameter("latmin", (Object)Float.valueOf(latmin)).setParameter("latmax", (Object)Float.valueOf(latmax)).setParameter("min", (Object)Float.valueOf(min)).setParameter("max", (Object)Float.valueOf(max)).setParameter("location", (Object)location);
        return query.getResultList();
    }

    @Override
    public List<Phase> findPhaseById(String catalog_id) {
        Query query = this.em.createQuery("select e from Phase e where e.catalog.id = :catalog_id  ").setParameter("catalog_id", (Object)catalog_id);
        return query.getResultList();
    }

    @Override
    public Catalog findBCatalogById(String id) {
        Catalog c = this.em.find(Catalog.class, id);
        return c;
    }

    @Override
    public void updateCatalog(Catalog c) {
        this.em.merge(c);
    }

    @Override
    public List<Catalog> generatePdfCatalog(String where) throws IOException {
        Query query = this.em.createQuery("select e from Catalog e where " + where + " and Auto_flag ='C' " + " order by e.originTime, e.originTimeFrac");
        return query.getResultList();
    }

    @Override
    public List<Catalog> generatePdfReport(String where) throws IOException {
        Query query = this.em.createQuery("select e from Catalog e where " + where + " and Auto_flag ='C' " + " order by e.originTime, e.originTimeFrac");
        return query.getResultList();
    }

    @Override
    public List<Phase> getPhases(Catalog c) throws IOException {
        List lst = this.em.createQuery("select s from Phase s where s.catalog.id= :id  and Auto_flag ='C' order by s.channelLocator.netCode, s.channelLocator.stationCode, s.channelLocator.locId, s.phaseTime, s.phaseTimeFrac").setParameter("id", (Object)c.getId()).getResultList();
        return lst;
    }

    @Override
    public Station findStationBy(String net, String sta, Date validDate) throws IOException {
        List lst = this.em.createQuery("select s from Station s where s.blockette050.networkCode=:net and s.blockette050.station=:sta and ((s.blockette050.startTime < :validDate and s.blockette050.endTime > :validDate) or (s.blockette050.startTime < :validDate and s.blockette050.endTime is null)  )").setParameter("net", (Object)net).setParameter("sta", (Object)sta).setParameter("validDate", validDate, TemporalType.TIMESTAMP).getResultList();
        if (lst.size() == 0) {
            return null;
        }
        return (Station)lst.get(0);
    }

    @Override
    public List<Channel> getChannelByStation(long id) {
        Query query = this.em.createQuery("select e from Channel e where e.station.id = :id  ").setParameter("id", (Object)id);
        return query.getResultList();
    }

    @Override
    public List<Catalog> generateXSL(String where) throws IOException {
        Query query = this.em.createQuery("select e from Catalog e where " + where + " order by e.originTime, e.originTimeFrac");
        return query.getResultList();
    }

    @Override
    public void add(LogStation logStation) {
    }

    @Override
    public void delete(Long logStationId) {
    }

    @Override
    public Collection<LogStation> getLogStationList(Date searchDate) {
        return null;
    }

    @Override
    public List<Catalog> loadCatalog() {
        return null;
    }
}

