/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogI;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.MagA;
import cn.org.gddsn.jopens.entity.MagI;
import cn.org.gddsn.jopens.entity.MagR;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.PhaseI;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.service.EventManagerService;
import cn.org.gddsn.jopens.service.StationManagerServiceBean;
import java.io.Serializable;
import java.util.Collection;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={EventManagerService.class})
@Remote(value={EventManagerService.class})
public class EventManagerServiceBean
implements EventManagerService,
Serializable {
    private static final long serialVersionUID = -1064638562199414051L;
    static Logger logger = Logger.getLogger(StationManagerServiceBean.class);
    @PersistenceContext
    private EntityManager manager;

    @Override
    public UniEventId findUniEventIdById(String id) {
        return this.manager.find(UniEventId.class, id);
    }

    @Override
    public void addUniEventId(UniEventId eventId) {
        this.manager.persist(eventId);
    }

    @Override
    public void removeUniEventId(String id) {
        this.manager.remove(this.findUniEventIdById(id));
    }

    @Override
    public void updateUniEventId(UniEventId eventId) {
        this.manager.merge(eventId);
    }

    @Override
    public EventInfo findEventInfoById(String id) {
        return this.manager.find(EventInfo.class, id);
    }

    public Collection<EventInfo> findEventInfoByUniEventId(String uniEventId) {
        return this.findUniEventIdById(uniEventId).getEventInfos();
    }

    @Override
    public void addEventInfo(UniEventId eventId, EventInfo eventInfo) {
        eventInfo.setUniEventId(eventId);
        eventId.getEventInfos().add(eventInfo);
        this.manager.merge(eventId);
    }

    @Override
    public void updateEventInfo(EventInfo eventInfo) {
        this.manager.merge(eventInfo);
    }

    @Override
    public void removeEventInfo(String id) {
        EventInfo eventInfo = this.manager.find(EventInfo.class, id);
        UniEventId uniEventId = eventInfo.getUniEventId();
        uniEventId.getEventInfos().remove(eventInfo);
        this.manager.merge(uniEventId);
        this.manager.remove(eventInfo);
    }

    @Override
    public Collection<Catalog> findCatalogByEventId(String eventId) {
        return this.findEventInfoById(eventId).getCatalogs();
    }

    @Override
    public Collection<Catalog> queryCorelation(String catalogId, double secondDiff, double locDiff) {
        Catalog catalog = (Catalog)this.manager.createQuery("select c from Catalog c where c.cataId = :cataId").setParameter("cataId", (Object)catalogId).getSingleResult();
        if (catalog == null) {
            return null;
        }
        return this.manager.createQuery("select c from Catalog c where ABS(c.epiLat - :epiLat) < :locDiff and ABS(c.epiLon - :epiLon) < :locDiff and ABS(c.oTime-:oTime)<:secondDiff").setParameter("epiLat", (Object)Float.valueOf(catalog.getLat())).setParameter("epiLon", (Object)Float.valueOf(catalog.getLon())).setParameter("locDiff", (Object)locDiff).setParameter("oTime", catalog.getOriginTime(), TemporalType.TIMESTAMP).setParameter("secondDiff", (Object)secondDiff).getResultList();
    }

    @Override
    public Catalog findCatalogById(long id) {
        return this.manager.find(Catalog.class, id);
    }

    public Catalog findCatalogByName(String catalogId) {
        return (Catalog)this.manager.createQuery("select c from Catalog c where c.cataId = :cataId").setParameter("cataId", (Object)catalogId).getSingleResult();
    }

    @Override
    public void addCatalog(Catalog cata) {
        this.manager.persist(cata);
    }

    @Override
    public void updateCatalog(Catalog cata) {
        this.manager.merge(cata);
    }

    @Override
    public void removeCatalog(long id) {
        CatalogI catalog = this.manager.find(CatalogI.class, id);
        EventInfo eventInfo = catalog.getEventInfo();
        eventInfo.getCatalogs().remove(catalog);
        this.manager.merge(eventInfo);
        this.manager.remove(catalog);
        this.manager.remove(this.findCatalogById(id));
    }

    @Override
    public Collection<Phase> findPhaseByCatalogId(String catalogId) {
        return this.findCatalogByName(catalogId).getPhases();
    }

    @Override
    public Phase findPhaseById(long id) {
        return this.manager.find(Phase.class, id);
    }

    @Override
    public void addPhase(Phase phase) {
        this.manager.persist(phase);
    }

    @Override
    public void removePhase(long id) {
        Phase phase = this.manager.find(PhaseI.class, id);
        Catalog catalog = phase.getCatalog();
        catalog.getPhases().remove(phase);
        this.manager.merge(catalog);
        this.manager.remove(phase);
    }

    @Override
    public void updatePhase(Phase phase) {
        this.manager.merge(phase);
    }

    @Override
    public MagI findMagIById(long id) {
        return this.manager.find(MagI.class, id);
    }

    @Override
    public MagA findMagAById(long id) {
        return this.manager.find(MagA.class, id);
    }

    @Override
    public MagR findMagRById(long id) {
        return this.manager.find(MagR.class, id);
    }

    @Override
    public void addMag(Mag mag) {
        this.manager.persist(mag);
    }

    @Override
    public void updateMag(Mag mag) {
        this.manager.merge(mag);
    }

    @Override
    public void removeMag(long id) {
        Mag mag = this.manager.find(MagI.class, id);
        Catalog catalog = mag.getCatalog();
        catalog.getMags().remove(mag);
        this.manager.merge(catalog);
        this.manager.remove(mag);
    }

    @Override
    public MagType findMagTypeById(String id) {
        return this.manager.find(MagType.class, id);
    }

    @Override
    public void addMagType(MagType magType) {
        this.manager.persist(magType);
    }

    @Override
    public void removeMagType(String id) {
        this.manager.remove(this.findMagTypeById(id));
    }

    @Override
    public void updateMagType(MagType magType) {
        this.manager.merge(magType);
    }

    @Override
    public Blockette034 findBlockette034ById(String id) {
        Blockette034 b034 = null;
        try {
            b034 = (Blockette034)this.manager.createQuery("select e from Blockette034 e where e.unitName= :uniName").setParameter("uniName", (Object)id).getSingleResult();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return b034;
    }

    public Collection<Blockette034> findAllBlockette034() {
        return this.manager.createQuery("select e from Blockette034 e").getResultList();
    }

    @Override
    public void addBlockette034(Blockette034 b034) {
        this.manager.persist(b034);
    }

    @Override
    public void removeBlockette034(String id) {
        this.manager.remove(this.findBlockette034ById(id));
    }

    @Override
    public void updateBlockette034(Blockette034 units) {
        this.manager.merge(units);
    }
}

