/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.SeedCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class LocalSeedCache
implements SeedCache {
    static Logger logger = Logger.getLogger(LocalSeedCache.class);
    private static String workingPath = "work";

    public LocalSeedCache() {
        String cd = System.getProperty("user.dir");
        File f = new File(cd, workingPath);
        if (!f.exists()) {
            f.mkdir();
        }
        logger.info("LocalSeedCache working path: " + new File(cd, workingPath));
    }

    public Dataless getDataless(long id) {
        Dataless dl = null;
        try {
            File p = new File(workingPath, "Dataless");
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(p, "" + id)), 8192));
            dl = (Dataless)ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dl;
    }

    public SeedConfig getSeedConfig(long id) {
        SeedConfig sc = null;
        try {
            File p = new File(workingPath, "SeedConfig");
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(p, "" + id)), 8192));
            sc = (SeedConfig)ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sc;
    }

    public void updateDataless(Dataless dl) {
        try {
            File p = new File(workingPath, "Dataless");
            if (!p.exists()) {
                p.mkdir();
            }
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(p, "" + dl.getId())), 8192));
            oos.writeObject(dl);
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateSeedConfig(SeedConfig sc) {
        try {
            File p = new File(workingPath, "SeedConfig");
            if (!p.exists()) {
                p.mkdir();
            }
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(p, "" + sc.getId())), 8192));
            oos.writeObject(sc);
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
    }
}

