/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.SeedCache;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.apache.log4j.Logger;

public class MemcachedSeedCache
implements SeedCache {
    static Logger logger = Logger.getLogger(MemcachedSeedCache.class);
    private MemcachedClient memcachedClient;

    public void setMemcachedClient(String memcachedServer) {
        try {
            this.memcachedClient = new MemcachedClient(AddrUtil.getAddresses(memcachedServer));
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public Dataless getDataless(long id) {
        if (this.memcachedClient == null) {
            return null;
        }
        Dataless dl = null;
        try {
            dl = (Dataless)this.memcachedClient.get("Dataless." + id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dl;
    }

    public SeedConfig getSeedConfig(long id) {
        if (this.memcachedClient == null) {
            return null;
        }
        SeedConfig sc = null;
        try {
            sc = (SeedConfig)this.memcachedClient.get("SeedConfig." + id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sc;
    }

    public void updateDataless(Dataless dl) {
        if (this.memcachedClient == null) {
            return;
        }
        try {
            this.memcachedClient.set("Dataless." + dl.getId(), 0, dl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("update dataless: " + dl.getId());
    }

    public void updateSeedConfig(SeedConfig sc) {
        if (this.memcachedClient == null) {
            return;
        }
        try {
            this.memcachedClient.set("SeedConfig." + sc.getId(), 0, sc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("update seedconfig: " + sc.getId());
    }

    public void destroy() {
        if (this.memcachedClient != null) {
            this.memcachedClient.shutdown(10L, TimeUnit.SECONDS);
            logger.info("shutdown memcachedClient.");
        }
    }
}

