/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.service.PhaseChild;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseParent
implements Comparable {
    private String netCode;
    private String stationCode;
    private float distance = 0.0f;
    private double staLat;
    private double staLon;
    private double epiLat;
    private double epiLon;
    private List<PhaseChild> phaseChildren = null;

    public PhaseParent(List<PhaseChild> phaseChildren) {
        this.phaseChildren = phaseChildren;
    }

    public PhaseParent(List<PhaseChild> phaseChildren, double epiLat, double epiLon, double staLat, double staLon) {
        this.phaseChildren = phaseChildren;
        this.epiLat = epiLat;
        this.epiLon = epiLon;
        this.staLat = staLat;
        this.staLon = staLon;
    }

    public PhaseParent(String netCode, String stationCode, float distance, double epiLat, double epiLon, double staLat, double staLon) {
        this.netCode = netCode;
        this.stationCode = stationCode;
        this.distance = distance;
        this.epiLat = epiLat;
        this.epiLon = epiLon;
        this.staLat = staLat;
        this.staLon = staLon;
    }

    public String getNetCode() {
        if (this.phaseChildren != null) {
            this.netCode = this.phaseChildren.get(0).getPhase().getChannelLocator().getNetCode();
        }
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public String getStationCode() {
        if (this.phaseChildren != null) {
            this.stationCode = this.phaseChildren.get(0).getPhase().getChannelLocator().getStationCode();
        }
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public float getDistance() {
        if (this.phaseChildren != null) {
            int size = this.phaseChildren.size();
            int i = 0;
            while (i < size) {
                this.distance += this.phaseChildren.get(i).getPhase().getDistance();
                ++i;
            }
        }
        if (this.phaseChildren != null) {
            this.distance /= (float)this.phaseChildren.size();
        }
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public List<PhaseChild> getPhaseChildren() {
        return this.phaseChildren;
    }

    public void setPhaseChildren(List<PhaseChild> phaseChildren) {
        this.phaseChildren = phaseChildren;
    }

    public double getStaLat() {
        return this.staLat;
    }

    public void setStaLat(double staLat) {
        this.staLat = staLat;
    }

    public double getStaLon() {
        return this.staLon;
    }

    public void setStaLon(double staLon) {
        this.staLon = staLon;
    }

    public double getEpiLat() {
        return this.epiLat;
    }

    public void setEpiLat(double epiLat) {
        this.epiLat = epiLat;
    }

    public double getEpiLon() {
        return this.epiLon;
    }

    public void setEpiLon(double epiLon) {
        this.epiLon = epiLon;
    }

    public int compareTo(Object o) {
        return (int)(this.distance - ((PhaseParent)o).getDistance());
    }

    public static void main(String[] args) {
        Object[] phaseParents = new PhaseParent[]{new PhaseParent("GD", "XFJ", 143.2f, 0.0, 0.0, 0.0, 0.0), new PhaseParent("GD", "LTK", 87.2f, 0.0, 0.0, 0.0, 0.0), new PhaseParent("GD", "HYJ", 55.0f, 0.0, 0.0, 0.0, 0.0), new PhaseParent("GD", "XIG", 133.2f, 0.0, 0.0, 0.0, 0.0)};
        Arrays.sort(phaseParents);
        int i = 0;
        while (i < phaseParents.length) {
            Object phaseParent = phaseParents[i];
            System.out.println(String.valueOf(((PhaseParent)phaseParent).getNetCode()) + "/" + ((PhaseParent)phaseParent).getStationCode() + " " + ((PhaseParent)phaseParent).getDistance());
            ++i;
        }
    }
}

