/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.EventExportPlugin;
import cn.org.gddsn.jopens.service.SeedExporterUtil;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.jopens.service.SpringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import org.jboss.annotation.ejb.ResourceAdapter;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.logging.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="cronTrigger", propertyValue="0 0 4 * * ?")})
@ResourceAdapter(value="quartz-ra.rar")
public class SeedVolumeContinueExporter
implements Job {
    static final Logger logger = Logger.getLogger(SeedVolumeContinueExporter.class);
    @Resource(name="SeedVolumeExporter/ContinueWaveformDir", type=String.class)
    private String continueWaveformDir = "/usr/local/jboss4/server/default/deploy/JOPENSEAR.ear/JOPENSWeb.war/seed/con";
    @Resource(name="ejb/BeanFactoryPath", type=String.class)
    private String beanFactoryPath;
    private SeedVolumeService stationService;

    private void export(Date fireTime) {
        long ms = (fireTime.getTime() / 1000L / 3600L / 24L - 1L) * 24L * 3600L * 1000L - (long)TimeZone.getDefault().getRawOffset();
        Dataless dl = this.stationService.findDefaultDataless();
        SeedExporterUtil util = new SeedExporterUtil();
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(this.stationService);
        seedExportPlugin.setWaveformService(this.stationService);
        util.setSeedExportPlugin(seedExportPlugin);
        util.setStartTime(new Date(ms));
        util.setEndTime(new Date(ms + 86400000L));
        int n = 0;
        for (Station s : dl.getSeedConfig().getStation()) {
            String net = s.getBlockette050().getNetworkCode();
            String station = s.getBlockette050().getStation();
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb, Locale.ENGLISH);
            fmt.format("%1$tY%1$tm%1$td.%2$s.%3$s.seed", new Date(ms), net, station);
            util.setFile(new File(this.continueWaveformDir, sb.substring(0)));
            util.setNetStationRegexp(net, station);
            logger.info((Object)("exporting " + net + "/" + station + " into " + util.getFile()));
            try {
                util.export();
                if (++n % 10 == 0) {
                    util.clear();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            logger.info((Object)("exported " + net + "/" + station + " into " + util.getFile()));
        }
        util.clear();
        NetworkInfo ni = this.stationService.findNetworkInfoSelf();
        String netCode = ni.getId();
        int i = 0;
        while (i < 24) {
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb, Locale.ENGLISH);
            fmt.format("%1$tY%1$tm%1$td%1$tH.%2$s.seed", new Date(ms + (long)(i * 3600) * 1000L), netCode);
            util.setStartTime(new Date(ms + (long)(i * 3600) * 1000L));
            util.setEndTime(new Date(ms + (long)((i + 1) * 3600) * 1000L));
            util.setFile(new File(this.continueWaveformDir, sb.substring(0)));
            util.setNetStationRegexp(".*", ".*");
            logger.info((Object)("exporting whole netowk data into " + util.getFile()));
            try {
                util.export();
                util.clear();
            }
            catch (IOException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            logger.info((Object)("exported whole netowk data into " + util.getFile()));
            ++i;
        }
    }

    @TransactionTimeout(value=0x6DDD00)
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.export(jobExecutionContext.getFireTime());
    }

    @PostConstruct
    public void postConstruct() {
        logger.info((Object)("beanFactoryPath = " + this.beanFactoryPath));
        logger.info((Object)("Exporter/ContinueWaveformDir = " + this.continueWaveformDir));
        try {
            SpringUtil util = new SpringUtil();
            util.loadBeanFactory();
            this.stationService = (SeedVolumeService)util.getBeanFactory().getBean("exportService");
            if (this.stationService == null) {
                logger.warn((Object)"Could not found exportService bean!");
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Init seedVolumeService export-service.xml failt!");
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

