/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.service.SeedCache;
import cn.org.gddsn.jopens.service.SeedVolumeMgrService;
import cn.org.gddsn.jopens.service.SeedVolumeServiceBean;
import cn.org.gddsn.jopens.service.SpringUtil;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
@Local(value={SeedVolumeMgrService.class})
@Remote(value={SeedVolumeMgrService.class})
public class SeedVolumeMgrServiceBean
extends SeedVolumeServiceBean
implements SeedVolumeMgrService {
    static Logger logger = Logger.getLogger(SeedVolumeMgrServiceBean.class);
    @Resource(name="ejb/BeanFactoryPath", type=String.class)
    private String beanFactoryPath = "META-INF/SeedCache.xml";

    @PostConstruct
    public void postConstruct() {
        logger.info("beanFactoryPath = " + this.beanFactoryPath);
        try {
            SpringUtil util = new SpringUtil();
            util.loadBeanFactory();
            this.seedCache = (SeedCache)util.getBeanFactory().getBean("seedCache");
        }
        catch (Exception ex) {
            logger.warn("Init seedCache in seedCache.xml failt!");
            logger.warn(ex.getMessage(), ex);
        }
    }

    @PreDestroy
    public void destroy() {
        logger.info("destroy SeedCache");
        if (this.seedCache != null) {
            this.seedCache.destroy();
        }
    }

    public void deleteEventInfo(String eventId, boolean bmeta) {
        EventInfo info = this.em.find(EventInfo.class, eventId);
        if (info == null) {
            return;
        }
        UniEventId uid = info.getUniEventId();
        if (uid != null) {
            uid.getEventInfos().remove(info);
            this.em.merge(uid);
            if (uid.getEventInfos().size() == 0) {
                this.em.remove(uid);
            }
        }
        this.em.createQuery("delete from WaveformEvent w where w.eventInfo.eventId= :eventId").setParameter("eventId", (Object)info.getEventId()).executeUpdate();
        for (Catalog c : info.getCatalogs()) {
            for (Mag m : c.getMags()) {
                m.setCatalog(null);
                this.em.remove(m);
            }
            this.em.remove(c);
        }
        this.em.remove(info);
        NetworkInfo ni = this.findNetworkInfoSelf();
        if (ni == null) {
            return;
        }
        Dataless ddl = this.em.find(Dataless.class, ni.getUniCode());
        Dataless dl = info.getDataless();
        if (dl != null && ddl != null && dl.getId() != ddl.getId()) {
            SeedConfig sc = dl.getSeedConfig();
            this.em.remove(dl);
            this.em.remove(sc);
        }
    }

    public EventInfo readEventInfo(String eventId) {
        long ct = System.currentTimeMillis();
        EventInfo ei = this.em.find(EventInfo.class, eventId);
        logger.info("ei time: " + (System.currentTimeMillis() - ct) / 1000L);
        ct = System.currentTimeMillis();
        this.cascadeDataless(ei.getDataless());
        for (Station s : ei.getDataless().getSeedConfig().getStation()) {
            for (Channel c : s.getChannel()) {
                if (c.getChannelInfo() == null) continue;
                c.getChannelInfo().getId();
            }
        }
        logger.info("cascadeDataless time: " + (System.currentTimeMillis() - ct) / 1000L);
        ct = System.currentTimeMillis();
        for (Catalog c : ei.getCatalogs()) {
            c.getMags().size();
            c.getPhases().size();
        }
        int size = ei.getWaveformEvents().size();
        logger.info("waveform time: " + (System.currentTimeMillis() - ct) / 1000L);
        logger.info("waveform size: " + size);
        return ei;
    }

    private void cascadeDataless(Dataless dl) {
        if (dl.getVolumeIndex().getBlockette011() != null) {
            dl.getVolumeIndex().getBlockette011().getPairs().size();
        }
        if (dl.getVolumeIndex().getBlockette012() != null) {
            dl.getVolumeIndex().getBlockette012().getSpans().size();
        }
        Abbreviation abbr = dl.getSeedConfig().getAbbreviation();
        abbr.getBlockette030().size();
        abbr.getBlockette031().size();
        abbr.getBlockette032().size();
        abbr.getBlockette033().size();
        abbr.getBlockette034().size();
        for (TimeSpan ts : dl.getTimeSpan()) {
            if (ts.getBlockette071() != null) {
                ts.getBlockette071().getMagnitudes().size();
            }
            ts.getBlockette072().size();
            ts.getBlockette074().size();
        }
        for (Station sta : dl.getSeedConfig().getStation()) {
            sta.getBlockette051().size();
            for (Channel chn : sta.getChannel()) {
                chn.getResponse().size();
                for (Response rsp : chn.getResponse()) {
                    if (rsp.getBlockette058() == null) continue;
                    rsp.getBlockette058().getHistoryValues().size();
                }
            }
        }
    }

    public List findEventList() {
        List caList = this.em.createQuery("select e from CatalogC e").getResultList();
        LinkedList<String> list = new LinkedList<String>();
        for (Catalog c : caList) {
            if (c.getEventInfo() == null) continue;
            list.add(c.getEventInfo().getEventId());
        }
        return list;
    }

    public void clearStationAndEvent() {
        NetworkInfo ni;
        List eiList = this.em.createQuery("select e from EventInfo e").getResultList();
        for (EventInfo ei : eiList) {
            this.deleteEventInfo(ei.getEventId(), true);
        }
        Dataless dl = this.findDefaultDataless();
        if (dl != null) {
            SeedConfig sc = dl.getSeedConfig();
            this.em.remove(dl);
            this.em.remove(sc);
        }
        if ((ni = this.findNetworkInfoSelf()) != null) {
            this.em.remove(ni);
        }
    }
}

