/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.CaliInfo;
import cn.org.gddsn.jopens.entity.CaliParam;
import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogA;
import cn.org.gddsn.jopens.entity.CatalogC;
import cn.org.gddsn.jopens.entity.CatalogSequence;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.OffLineInfo;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.Pick;
import cn.org.gddsn.jopens.entity.ReirInfo;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.Sourceparameter;
import cn.org.gddsn.jopens.entity.StationAmplitude;
import cn.org.gddsn.jopens.entity.StationMagnitude;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.service.SeedCache;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.jopens.service.SpringUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;
import org.jboss.ejb3.entity.HibernateSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={SeedVolumeService.class})
@Remote(value={SeedVolumeService.class})
@PoolClass(value=StrictMaxPool.class, maxSize=5, timeout=10000L)
public class SeedVolumeServiceBean
implements SeedVolumeService {
    static Logger logger = Logger.getLogger(SeedVolumeServiceBean.class);
    @PersistenceContext
    protected EntityManager em;
    @Resource(name="ejb/BeanFactoryPath", type=String.class)
    private String beanFactoryPath;
    protected SeedCache seedCache = null;

    @PostConstruct
    public void postConstruct() {
        logger.info("beanFactoryPath = " + this.beanFactoryPath);
        try {
            SpringUtil util = new SpringUtil();
            util.loadBeanFactory();
            this.seedCache = (SeedCache)util.getBeanFactory().getBean("seedCache");
        }
        catch (Exception ex) {
            logger.warn("Init seedCache in seedCache.xml failt!");
            logger.warn(ex.getMessage(), ex);
        }
    }

    @PreDestroy
    public void destroy() {
        logger.info("destroy SeedCache");
        if (this.seedCache != null) {
            this.seedCache.destroy();
        }
    }

    @Override
    public void writeReplication(NetworkInfo ni) {
        if (this.em instanceof HibernateSession) {
            HibernateSession hs = (HibernateSession)this.em;
            Session session = hs.getHibernateSession();
            logger.info(ni.getId());
            session.replicate((Object)ni, ReplicationMode.LATEST_VERSION);
        }
    }

    @Override
    public Catalog findCatalog(String catalogId) {
        Catalog c = this.em.find(Catalog.class, catalogId);
        if (c == null) {
            return null;
        }
        c.getPhases().size();
        c.getMags().size();
        return c;
    }

    @Override
    public List<Catalog> findCatalogByEventId(String eventId) {
        EventInfo ei = this.em.find(EventInfo.class, eventId);
        for (Catalog c : ei.getCatalogs()) {
            c.getPhases().size();
            c.getMags().size();
        }
        return ei.getCatalogs();
    }

    @Override
    public List<Waveform> getWaveform(String eventId) {
        return this.em.createQuery("select e from WaveformEvent e where e.eventInfo.eventId= :eventId order by e.channelLocator.netCode, e.channelLocator.stationCode, e.channelLocator.locId, e.channelLocator.chanCode, e.startTime, e.startTimeFrac").setParameter("eventId", (Object)eventId).getResultList();
    }

    @Override
    public List<Waveform> getWaveform(String eventId, ChannelLocator cl) {
        return this.em.createQuery("select e from WaveformEvent e where e.eventInfo.eventId= :eventId and e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan order by e.startTime, e.startTimeFrac").setParameter("net", (Object)cl.getNetCode()).setParameter("sta", (Object)cl.getStationCode()).setParameter("locId", (Object)cl.getLocId()).setParameter("chan", (Object)cl.getChanCode()).setParameter("eventId", (Object)eventId).getResultList();
    }

    @Override
    public int[] getWaveformChunkSize(String eventId, ChannelLocator cl) {
        List list = this.em.createQuery("select e.recLenth from WaveformEvent e where e.eventInfo.eventId= :eventId e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan ").setParameter("net", (Object)cl.getNetCode()).setParameter("sta", (Object)cl.getStationCode()).setParameter("locId", (Object)cl.getLocId()).setParameter("chan", (Object)cl.getChanCode()).setParameter("eventId", (Object)eventId).getResultList();
        if (list.size() == 0) {
            return null;
        }
        Object[] obj = (Object[])list.get(0);
        int[] par = new int[]{Integer.parseInt(obj[0].toString()), list.size()};
        return par;
    }

    @Override
    public List<Waveform> getWaveform(Date startTime, Date endTime) {
        return this.em.createQuery("select e from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime order by e.channelLocator.netCode, e.channelLocator.stationCode, e.channelLocator.locId, e.channelLocator.chanCode, e.startTime, e.startTimeFrac").setParameter("startTime", startTime, TemporalType.TIMESTAMP).setParameter("endTime", endTime, TemporalType.TIMESTAMP).getResultList();
    }

    @Override
    public List<Waveform> getWaveform(Date startTime, Date endTime, String[] nets, String[] stas) {
        StringBuffer sb = new StringBuffer();
        sb.append(" AND e.channelLocator.netCode in (");
        int i = 0;
        while (i < nets.length) {
            if (i == nets.length - 1) {
                sb.append("'" + nets[i] + "') ");
            } else {
                sb.append("'" + nets[i] + "', ");
            }
            ++i;
        }
        sb.append(" AND e.channelLocator.stationCode in (");
        i = 0;
        while (i < stas.length) {
            if (i == stas.length - 1) {
                sb.append("'" + stas[i] + "') ");
            } else {
                sb.append("'" + stas[i] + "', ");
            }
            ++i;
        }
        return this.em.createQuery("select e from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime " + sb.substring(0) + "order by e.channelLocator.netCode, e.channelLocator.stationCode, " + "e.channelLocator.locId, e.channelLocator.chanCode, e.startTime, e.startTimeFrac").setParameter("startTime", startTime, TemporalType.TIMESTAMP).setParameter("endTime", endTime, TemporalType.TIMESTAMP).getResultList();
    }

    @Override
    public List<Waveform> getWaveform(Date startTime, Date endTime, ChannelLocator cl) {
        return this.em.createQuery("select e from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime and e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan order by e.startTime, e.startTimeFrac").setParameter("startTime", startTime, TemporalType.TIMESTAMP).setParameter("endTime", endTime, TemporalType.TIMESTAMP).setParameter("net", (Object)cl.getNetCode()).setParameter("sta", (Object)cl.getStationCode()).setParameter("locId", (Object)cl.getLocId()).setParameter("chan", (Object)cl.getChanCode()).getResultList();
    }

    @Override
    public int[] getWaveformChunkSize(Date startTime, Date endTime, ChannelLocator cl) {
        List list = this.em.createQuery("select e.recLenth from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan ").setParameter("startTime", startTime, TemporalType.TIMESTAMP).setParameter("endTime", endTime, TemporalType.TIMESTAMP).setParameter("net", (Object)cl.getNetCode()).setParameter("sta", (Object)cl.getStationCode()).setParameter("locId", (Object)cl.getLocId()).setParameter("chan", (Object)cl.getChanCode()).getResultList();
        if (list.size() == 0) {
            return null;
        }
        Object[] obj = (Object[])list.get(0);
        int[] par = new int[]{Integer.parseInt(obj[0].toString()), list.size()};
        return par;
    }

    public void deleteRtsEventInfo1(int timeoutHours) {
        Date deadTime = new Date(new Date().getTime() - (long)(timeoutHours * 3600) * 1000L);
        List list = this.em.createQuery("select e from EventInfo e where e.startTime <:deadTime").setParameter("deadTime", deadTime, TemporalType.TIMESTAMP).getResultList();
        for (EventInfo info : list) {
            logger.info("Event id: " + info.getEventId());
            this.deleteEventInfo(info.getEventId(), true);
        }
    }

    @Override
    public void deleteRtsEventInfo(int timeoutHours) {
        Date deadTime = new Date(new Date().getTime() - (long)(timeoutHours * 3600) * 1000L);
        List list = this.em.createQuery("select e from CatalogA e where e.originTime <:deadTime").setParameter("deadTime", deadTime, TemporalType.TIMESTAMP).getResultList();
        for (CatalogA c : list) {
            logger.info("Catalog id: " + c.getCataName());
            if (c.getEventInfo() == null) continue;
            logger.info("Event id: " + c.getEventInfo().getEventId());
            this.deleteEventInfo(c.getEventInfo().getEventId(), true);
        }
    }

    @Override
    public void deleteEventInfo(String eventId, boolean bRts) {
        EventInfo info = this.em.find(EventInfo.class, eventId);
        if (info == null) {
            return;
        }
        UniEventId uid = info.getUniEventId();
        if (uid != null) {
            uid.getEventInfos().remove(info);
            this.em.merge(uid);
            if (uid.getEventInfos().size() == 0) {
                this.em.remove(uid);
            }
        }
        this.em.createQuery("delete from WaveformEvent w where w.eventInfo.eventId= :eventId").setParameter("eventId", (Object)info.getEventId()).executeUpdate();
        Iterator<Catalog> it = info.getCatalogs().iterator();
        while (it.hasNext()) {
            Catalog c = it.next();
            this.deleteCatalogForeignKey(this.em, c.getId());
            it.remove();
            for (Mag m : c.getMags()) {
                m.setCatalog(null);
                this.em.remove(m);
            }
            this.em.remove(c);
        }
        this.em.remove(info);
        NetworkInfo ni = this.findNetworkInfoSelf();
        if (ni == null) {
            return;
        }
        Dataless ddl = this.em.find(Dataless.class, ni.getUniCode());
        Dataless dl = info.getDataless();
        if (dl != null && ddl != null && dl.getId() != ddl.getId()) {
            this.em.remove(dl);
        }
    }

    @Override
    public EventInfo findEventInfo(String eventId) {
        EventInfo info = this.em.find(EventInfo.class, eventId);
        if (info != null) {
            info.getCatalogs().size();
            for (Catalog c : info.getCatalogs()) {
                c.getPhases().size();
                c.getMags().size();
            }
        }
        return info;
    }

    @Override
    public void updateEventInfo(EventInfo info) {
        this.em.merge(info);
        Catalog cata = null;
        for (Catalog c1 : info.getCatalogs()) {
            if (!(c1 instanceof CatalogC)) continue;
            cata = c1;
            break;
        }
        this.updateCatalogSequence(this.em, cata);
    }

    @Override
    public void updateRtsEventInfo(String eventId, Date startTime, Date endTime) {
        boolean exist;
        List list = this.em.createQuery("select e from EventInfo e where e.eventId= :eventId ").setParameter("eventId", (Object)eventId).getResultList();
        boolean bl = exist = list.size() != 0;
        if (!exist) {
            EventInfo info = new EventInfo();
            info.setEventId(eventId);
            info.setStartTime(startTime);
            info.setEndTime(endTime);
            NetworkInfo ni = this.findNetworkInfoSelf();
            if (ni == null) {
                logger.warn("could not find self NetworkInfo.");
                return;
            }
            Dataless dl = this.em.find(Dataless.class, ni.getUniCode());
            info.setDataless(dl);
            this.em.merge(info);
        } else {
            EventInfo info = (EventInfo)list.get(0);
            info.setStartTime(startTime);
            info.setEndTime(endTime);
            this.em.merge(info);
        }
    }

    @Override
    public EventInfo readEventInfo(String eventId) {
        long ct = System.currentTimeMillis();
        EventInfo ei = this.em.find(EventInfo.class, eventId);
        logger.info("ei time: " + (System.currentTimeMillis() - ct) / 1000L);
        ct = System.currentTimeMillis();
        ei.setDataless(this.cascadeDataless(ei.getDataless().getId()));
        ei.getDataless().setSeedConfig(this.cascadeSeedConfig(ei.getDataless().getSeedConfig().getId()));
        logger.info("cascadeDataless time: " + (System.currentTimeMillis() - ct) / 1000L);
        ct = System.currentTimeMillis();
        int size = ei.getWaveformEvents().size();
        logger.info("waveform time: " + (System.currentTimeMillis() - ct) / 1000L);
        logger.info("waveform size: " + size);
        return ei;
    }

    private Dataless cascadeDataless(long id) {
        Dataless dl = this.em.find(Dataless.class, id);
        if (dl == null) {
            return dl;
        }
        if (dl.getSaveTime() == null) {
            dl.setSaveTime(new Timestamp(new Date().getTime()));
            dl = this.em.merge(dl);
            logger.info("add Dataless savetime");
        }
        Dataless cacheDl = null;
        if (this.seedCache != null && (cacheDl = this.seedCache.getDataless(dl.getId())) != null && cacheDl.getId() == dl.getId() && cacheDl.getSaveTime().getTime() == dl.getSaveTime().getTime()) {
            logger.info("use server side cache Dataless: " + dl.getId());
            return cacheDl;
        }
        if (dl.getVolumeIndex().getBlockette011() != null) {
            dl.getVolumeIndex().getBlockette011().getPairs().size();
        }
        if (dl.getVolumeIndex().getBlockette012() != null) {
            dl.getVolumeIndex().getBlockette012().getSpans().size();
        }
        for (TimeSpan ts : dl.getTimeSpan()) {
            if (ts.getBlockette071() != null) {
                ts.getBlockette071().getMagnitudes().size();
            }
            ts.getBlockette072().size();
            ts.getBlockette074().size();
        }
        if (this.seedCache != null) {
            this.seedCache.updateDataless(dl);
        }
        return dl;
    }

    private SeedConfig cascadeSeedConfig(long id) {
        SeedConfig sc = this.em.find(SeedConfig.class, id);
        if (sc == null) {
            return sc;
        }
        if (sc.getSaveTime() == null) {
            sc.setSaveTime(new Timestamp(new Date().getTime()));
            sc = this.em.merge(sc);
            logger.info("add SeedConfig savetime");
        }
        SeedConfig cacheSC = null;
        if (this.seedCache != null && (cacheSC = this.seedCache.getSeedConfig(sc.getId())) != null && cacheSC.getId() == sc.getId() && cacheSC.getSaveTime().getTime() == sc.getSaveTime().getTime()) {
            logger.info("use server side cache SeedConfig: " + sc.getId());
            return cacheSC;
        }
        Abbreviation abbr = sc.getAbbreviation();
        abbr.getBlockette030().size();
        abbr.getBlockette031().size();
        abbr.getBlockette032().size();
        abbr.getBlockette033().size();
        abbr.getBlockette034().size();
        for (Station sta : sc.getStation()) {
            sta.getBlockette051().size();
            for (Channel chn : sta.getChannel()) {
                chn.getResponse().size();
                for (Response rsp : chn.getResponse()) {
                    if (rsp.getBlockette058() == null) continue;
                    rsp.getBlockette058().getHistoryValues().size();
                }
            }
        }
        if (this.seedCache != null) {
            this.seedCache.updateSeedConfig(sc);
        }
        return sc;
    }

    @Override
    public EventInfo getTimeInfo(String eventId) {
        EventInfo ei = this.em.find(EventInfo.class, eventId);
        if (ei.getStartTime() != null && ei.getEndTime() != null) {
            ei.getDataless().getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
            ei.getDataless().getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
        } else {
            ei.setStartTime(ei.getDataless().getVolumeIndex().getBlockette010().getStartTime());
            ei.setEndTime(ei.getDataless().getVolumeIndex().getBlockette010().getEndTime());
        }
        return ei;
    }

    @Override
    public Dataless findDatalessByEventId(String eventId) {
        return this.findDatalessByEventId(eventId, true, true);
    }

    @Override
    public Dataless findDatalessByEventId(String eventId, boolean dlCascade, boolean scCascade) {
        EventInfo ei = this.em.find(EventInfo.class, eventId);
        if (dlCascade) {
            ei.setDataless(this.cascadeDataless(ei.getDataless().getId()));
        }
        if (scCascade) {
            ei.getDataless().setSeedConfig(this.cascadeSeedConfig(ei.getDataless().getSeedConfig().getId()));
        }
        if (ei.getStartTime() != null && ei.getEndTime() != null) {
            ei.getDataless().getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
            ei.getDataless().getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
        }
        return ei.getDataless();
    }

    @Override
    public long findDatalessIdByEventId(String eventId) {
        EventInfo ei = this.em.find(EventInfo.class, eventId);
        if (ei.getStartTime() != null && ei.getEndTime() != null) {
            ei.getDataless().getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
            ei.getDataless().getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
        }
        return ei.getDataless().getId();
    }

    @Override
    public NetworkInfo findNetworkInfoSelf() {
        List niList = this.em.createQuery("select e from NetworkInfo e where e.self = :self").setParameter("self", (Object)"Y").getResultList();
        if (niList.size() == 0) {
            return null;
        }
        return (NetworkInfo)niList.get(0);
    }

    @Override
    public NetworkInfo findNetworkInfo(String netCode) {
        return this.em.find(NetworkInfo.class, netCode);
    }

    @Override
    public void writeNetworkInfo(NetworkInfo ni) {
        this.em.merge(ni);
    }

    @Override
    public Dataless findDefaultDataless() {
        NetworkInfo ni = this.findNetworkInfoSelf();
        if (ni == null) {
            return null;
        }
        Dataless dl = this.em.find(Dataless.class, ni.getUniCode());
        dl = this.cascadeDataless(dl.getId());
        dl.setSeedConfig(this.cascadeSeedConfig(dl.getSeedConfig().getId()));
        return dl;
    }

    @Override
    public Dataless findDatalessById(long id) {
        return this.findDatalessById(id, true, true);
    }

    @Override
    public Dataless findDatalessById(long id, boolean dlCascade, boolean scCascade) {
        Dataless dl = this.em.find(Dataless.class, id);
        if (dlCascade) {
            dl = this.cascadeDataless(dl.getId());
        }
        if (scCascade) {
            dl.setSeedConfig(this.cascadeSeedConfig(dl.getSeedConfig().getId()));
        }
        return dl;
    }

    @Override
    public void deleteDataless(long id) {
        Dataless dl = this.em.find(Dataless.class, id);
        if (dl != null) {
            this.em.remove(dl);
            this.em.remove(dl.getSeedConfig());
        }
    }

    @Override
    public long writeDataless(Dataless dataless) {
        return this.em.merge(dataless).getId();
    }

    @Override
    public void writeUniEventId(UniEventId uniEvent) {
        this.em.persist(uniEvent);
        this.em.flush();
    }

    @Override
    public void updateUniEventId(String uniEventId, EventInfo eventInfo) {
        UniEventId uniEvent = this.em.find(UniEventId.class, uniEventId);
        if (uniEvent == null) {
            return;
        }
        if (eventInfo.getCatalogs().isEmpty()) {
            return;
        }
        Catalog myCata = eventInfo.getCatalogs().get(0);
        Iterator<EventInfo> it = uniEvent.getEventInfos().iterator();
        block0: while (it.hasNext()) {
            EventInfo ei = it.next();
            for (Catalog c : ei.getCatalogs()) {
                if (!c.getNetCode().equals(myCata.getNetCode())) continue;
                it.remove();
                ei.setUniEventId(null);
                this.em.merge(uniEvent);
                this.em.remove(ei);
                this.em.flush();
                continue block0;
            }
        }
        uniEvent.getEventInfos().add(eventInfo);
        eventInfo.setUniEventId(uniEvent);
        this.em.merge(uniEvent);
        this.em.flush();
    }

    @Override
    public void writeEventInfo(EventInfo eventInfo) {
        NetworkInfo ni = this.findNetworkInfoSelf();
        if (ni == null) {
            logger.warn("Could default NetworkInfo");
            return;
        }
        this.em.persist(eventInfo);
        this.em.flush();
        Catalog cata = null;
        for (Catalog c1 : eventInfo.getCatalogs()) {
            if (!(c1 instanceof CatalogC)) continue;
            cata = c1;
            break;
        }
        this.updateCatalogSequence(this.em, cata);
    }

    @Override
    public ReirInfo writeReirInfo(ReirInfo info) {
        return this.em.merge(info);
    }

    @Override
    public ReirInfo readReirInfo(long id) {
        ReirInfo info = this.em.find(ReirInfo.class, id);
        if (info != null && info.getCatalog() != null) {
            info.getCatalog().getPhases().size();
            info.getCatalog().getMags().size();
        }
        return info;
    }

    @Override
    public List<ReirInfo> findReirInfo(String sort) {
        return this.em.createQuery("select e from ReirInfo e ORDER BY " + sort + " DESC").getResultList();
    }

    @Override
    public MagType findMagTypeById(String id) {
        return this.em.find(MagType.class, id);
    }

    @Override
    public void addMagType(MagType magType) {
        this.em.persist(magType);
    }

    @Override
    public void removeMagType(String id) {
        this.em.remove(this.findMagTypeById(id));
    }

    @Override
    public void updateMagType(MagType magType) {
        this.em.merge(magType);
    }

    @Override
    public String findNewestEventId() {
        List list = this.em.createQuery("select e from EventInfo e order by e.startTime desc limit 1").getResultList();
        if (list.size() == 0) {
            return null;
        }
        EventInfo info = (EventInfo)list.get(0);
        return info.getEventId();
    }

    @Override
    public List<Catalog> findCatalogR(EventInfo localInfo, float maxOriginDiff, float maxLocDiff, float maxMagDiff) {
        Date otime = localInfo.getCatalogs().get(0).getOriginTime();
        Date minTime = new Date(otime.getTime() - (long)((int)maxOriginDiff) * 1000L);
        Date maxTime = new Date(otime.getTime() + (long)((int)maxOriginDiff) * 1000L);
        float lat = localInfo.getCatalogs().get(0).getLat();
        float minLat = lat - maxLocDiff;
        float maxLat = lat + maxLocDiff;
        float lon = localInfo.getCatalogs().get(0).getLon();
        float minLon = lon - maxLocDiff;
        float maxLon = lon + maxLocDiff;
        float m = localInfo.getCatalogs().get(0).getM();
        float minM = m - maxMagDiff;
        float maxM = m + maxMagDiff;
        List r = this.em.createQuery("select e from Catalog e where e.originTime > :minTime and e.originTime < :maxTime and e.lat > :minLat and e.lat < :maxLat and e.lon > :minLon and e.lon < :maxLon and e.m > :minM and e.m < :maxM e.eventInfo=null order by e.netCode, e.originTime").setParameter("minTime", minTime, TemporalType.TIMESTAMP).setParameter("maxTime", maxTime, TemporalType.TIMESTAMP).setParameter("minLat", (Object)Float.valueOf(minLat)).setParameter("maxLat", (Object)Float.valueOf(maxLat)).setParameter("minLon", (Object)Float.valueOf(minLon)).setParameter("maxLon", (Object)Float.valueOf(maxLon)).setParameter("minM", (Object)Float.valueOf(minM)).setParameter("maxM", (Object)Float.valueOf(maxM)).getResultList();
        r.addAll(localInfo.getCatalogs());
        return r;
    }

    @Override
    public List<Catalog> findCatalog(Catalog c, float maxOriginDiff, float maxLocDiff, float maxMagDiff, boolean cascade) {
        Date otime = c.getOriginTime();
        Date minTime = new Date(otime.getTime() - (long)((int)maxOriginDiff) * 1000L);
        Date maxTime = new Date(otime.getTime() + (long)((int)maxOriginDiff) * 1000L);
        float lat = c.getLat();
        float minLat = lat - maxLocDiff;
        float maxLat = lat + maxLocDiff;
        float lon = c.getLon();
        float minLon = lon - maxLocDiff;
        float maxLon = lon + maxLocDiff;
        float m = c.getM();
        float minM = m - maxMagDiff;
        float maxM = m + maxMagDiff;
        List cataList = this.em.createQuery("select e from Catalog e where e.originTime > :minTime and e.originTime < :maxTime and e.lat > :minLat and e.lat < :maxLat and e.lon > :minLon and e.lon < :maxLon and e.m > :minM and e.m < :maxM order by e.netCode, e.originTime").setParameter("minTime", minTime, TemporalType.TIMESTAMP).setParameter("maxTime", maxTime, TemporalType.TIMESTAMP).setParameter("minLat", (Object)Float.valueOf(minLat)).setParameter("maxLat", (Object)Float.valueOf(maxLat)).setParameter("minLon", (Object)Float.valueOf(minLon)).setParameter("maxLon", (Object)Float.valueOf(maxLon)).setParameter("minM", (Object)Float.valueOf(minM)).setParameter("maxM", (Object)Float.valueOf(maxM)).getResultList();
        for (Catalog cat : cataList) {
            cat.getPhases().size();
            cat.getMags().size();
        }
        return cataList;
    }

    @Override
    public List<Catalog> findCatalog(EventInfo localInfo, float maxOriginDiff, float maxLocDiff, float maxMagDiff) {
        Date otime = localInfo.getCatalogs().get(0).getOriginTime();
        Date minTime = new Date(otime.getTime() - (long)((int)maxOriginDiff) * 1000L);
        Date maxTime = new Date(otime.getTime() + (long)((int)maxOriginDiff) * 1000L);
        float lat = localInfo.getCatalogs().get(0).getLat();
        float minLat = lat - maxLocDiff;
        float maxLat = lat + maxLocDiff;
        float lon = localInfo.getCatalogs().get(0).getLon();
        float minLon = lon - maxLocDiff;
        float maxLon = lon + maxLocDiff;
        float m = localInfo.getCatalogs().get(0).getM();
        float minM = m - maxMagDiff;
        float maxM = m + maxMagDiff;
        return this.em.createQuery("select e from Catalog e where e.originTime > :minTime and e.originTime < :maxTime and e.lat > :minLat and e.lat < :maxLat and e.lon > :minLon and e.lon < :maxLon and e.m > :minM and e.m < :maxM order by e.eventInfo.uniEventId.nationEventId, e.netCode, e.originTime").setParameter("minTime", minTime, TemporalType.TIMESTAMP).setParameter("maxTime", maxTime, TemporalType.TIMESTAMP).setParameter("minLat", (Object)Float.valueOf(minLat)).setParameter("maxLat", (Object)Float.valueOf(maxLat)).setParameter("minLon", (Object)Float.valueOf(minLon)).setParameter("maxLon", (Object)Float.valueOf(maxLon)).setParameter("minM", (Object)Float.valueOf(minM)).setParameter("maxM", (Object)Float.valueOf(maxM)).getResultList();
    }

    @Override
    public SeedConfig findSeedConfig(long id) {
        return this.findSeedConfig(id, true);
    }

    @Override
    public SeedConfig findSeedConfig(long id, boolean scCascade) {
        SeedConfig sc = this.em.find(SeedConfig.class, id);
        if (sc == null) {
            return null;
        }
        if (scCascade) {
            sc = this.cascadeSeedConfig(sc.getId());
        }
        return sc;
    }

    @Override
    public void deleteUniEventId(String uniEventId) {
        UniEventId ue = this.em.find(UniEventId.class, uniEventId);
        if (ue != null) {
            this.em.remove(ue);
        }
    }

    @Override
    public void deleteCatalog(String eventInfoId, String catalogId) {
        if (eventInfoId == null || catalogId == null) {
            return;
        }
        EventInfo ei = this.em.find(EventInfo.class, eventInfoId);
        Catalog c = this.em.find(Catalog.class, catalogId);
        if (ei == null || c == null) {
            logger.info("return null");
            return;
        }
        this.deleteCatalogForeignKey(this.em, catalogId);
        ei.getCatalogs().remove(c);
        c.setEventInfo(null);
        this.em.remove(c);
    }

    private void deleteCatalogForeignKey(EntityManager em, String catalogId) {
        if (catalogId == null) {
            return;
        }
        em.createQuery("delete from Sourceparameter e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from ReirInfo e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from Momenttensor e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from RegFocmec e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from Sourceprocess e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
    }

    @Override
    public void replaceCatalog(String eventInfoId, String origCatalogId, Catalog newCatalog) {
        EventInfo ei = this.em.find(EventInfo.class, eventInfoId);
        Catalog origCatalog = this.em.find(Catalog.class, origCatalogId);
        if (ei == null || origCatalog == null) {
            logger.info("return null");
            return;
        }
        logger.info(origCatalogId);
        origCatalog.updateCatalog(newCatalog);
        for (Mag m : origCatalog.getMags()) {
            this.em.remove(m);
        }
        for (Phase p : origCatalog.getPhases()) {
            this.em.remove(p);
        }
        origCatalog.setMags(newCatalog.getMags());
        origCatalog.setPhases(newCatalog.getPhases());
        for (Mag m : origCatalog.getMags()) {
            m.setCatalog(origCatalog);
        }
        for (Phase p : origCatalog.getPhases()) {
            p.setCatalog(origCatalog);
        }
        this.em.merge(origCatalog);
        this.updateCatalogSequence(this.em, newCatalog);
    }

    @Override
    public void writeCaliInfo(CaliInfo ci) {
        this.em.persist(ci);
    }

    @Override
    public CaliInfo findCaliInfo(long id) {
        return this.em.find(CaliInfo.class, id);
    }

    @Override
    public void writeCaliParam(CaliParam cp) {
        this.em.persist(cp);
    }

    @Override
    public void findClear() {
        this.em.clear();
    }

    @Override
    public List<ReirInfo> findReirInfo() {
        return null;
    }

    @Override
    public void writeSourceParameter(String catalogId, Sourceparameter sp) {
        Catalog c = this.em.find(Catalog.class, catalogId);
        if (c == null) {
            return;
        }
        this.em.createQuery("delete from Sourceparameter s where s.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        sp.setCatalog(c);
        sp.setEventInfo(c.getEventInfo());
        this.em.merge(sp);
    }

    @Override
    public OffLineInfo getOffLineInfo(String eventInfoId) {
        EventInfo ei = this.em.find(EventInfo.class, eventInfoId);
        if (ei == null) {
            return null;
        }
        return ei.getOffLineInfo();
    }

    @Override
    public List<EventInfo> findEventInfoList(Date begDate, Date endDate) {
        return this.em.createQuery("select e from EventInfo e where e.startTime >= :beg  and e.startTime < :end order by e.startTime").setParameter("beg", (Object)begDate).setParameter("end", (Object)endDate).getResultList();
    }

    @Override
    public Mag findMag(long id) {
        return this.em.find(Mag.class, id);
    }

    @Override
    public StationAmplitude findStationAmplitudeById(String id) {
        return this.em.find(StationAmplitude.class, id);
    }

    @Override
    public StationMagnitude findStationMagnitudeById(String id) {
        return this.em.find(StationMagnitude.class, id);
    }

    @Override
    public Pick findPickById(String pickId) {
        return this.em.find(Pick.class, pickId);
    }

    @Override
    public void updateCatalog(String cataId, List<StationMagnitude> sms) {
        Catalog c = this.em.find(Catalog.class, cataId);
        if (c == null) {
            return;
        }
        for (StationMagnitude sm : sms) {
            StationMagnitude _sm = c.findStationMagnitude(sm.getId());
            if (_sm != null) {
                _sm.setCatalog(null);
                c.getStationMagnitudes().remove(_sm);
                this.em.remove(_sm);
            }
            sm.setCatalog(c);
            c.getStationMagnitudes().add(sm);
        }
        this.em.merge(c);
    }

    @Override
    public List<String> findCatalogSequenceName() {
        List css = this.em.createQuery("select e from CatalogSequence e order by e.sequenName").getResultList();
        LinkedList<String> sns = new LinkedList<String>();
        for (CatalogSequence cs : css) {
            sns.add(cs.getSequenName());
        }
        return sns;
    }

    private void updateCatalogSequence(EntityManager em, Catalog cata) {
        CatalogSequence cs;
        String seqName;
        if (cata != null && (seqName = cata.getSequenName()) != null && (cs = em.find(CatalogSequence.class, seqName)) == null) {
            cs = new CatalogSequence();
            cs.setSequenName(seqName);
            cs.setCatalog(em.find(Catalog.class, cata.getId()));
            em.persist(cs);
        }
    }
}

