/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.SpringUtil;
import cn.org.gddsn.jopens.service.StationManagerService;
import cn.org.gddsn.jopens.service.StationSyncService;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

@Stateless
@Local(value={StationSyncService.class})
@Remote(value={StationSyncService.class})
public class StationSyncServiceBean
implements StationSyncService {
    static Logger logger = Logger.getLogger(StationSyncServiceBean.class);
    @Resource(name="ejb/BeanFactoryPath", type=String.class)
    private String beanFactoryPath;
    private StationManagerService stationManagerService;
    @PersistenceContext
    private EntityManager em;

    @PostConstruct
    public void postConstruct() {
        logger.info("beanFactoryPath = " + this.beanFactoryPath);
        try {
            SpringUtil util = new SpringUtil();
            util.loadBeanFactory();
            this.stationManagerService = (StationManagerService)util.getBeanFactory().getBean("stationManagerService");
        }
        catch (Exception ex) {
            logger.warn("Init stationManagerService in sync-service.xml failt!");
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void checkStationManagerService() {
        if (this.stationManagerService == null) {
            throw new IllegalArgumentException("stationManagerService should not be null");
        }
    }

    public void uploadNetworkInfo(String id) {
        this.checkStationManagerService();
        NetworkInfo ni = this.em.find(NetworkInfo.class, id);
        if (ni == null) {
            return;
        }
        NetworkInfo rni = this.stationManagerService.findNetworkInfoById(id);
        if (rni == null) {
            rni = new NetworkInfo();
        }
        try {
            BeanUtils.copyProperties((Object)rni, (Object)ni);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.stationManagerService.updateNetworkInfo(rni);
    }

    public void downloadNetworkInfo(String id) {
        this.checkStationManagerService();
        NetworkInfo ni = this.em.find(NetworkInfo.class, id);
        NetworkInfo rni = this.stationManagerService.findNetworkInfoById(id);
        try {
            BeanUtils.copyProperties((Object)ni, (Object)rni);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.em.merge(ni);
    }

    public void uploadStation(String eid) {
        this.checkStationManagerService();
        List lst = this.em.createQuery("select s from Station s where s.exchangeId = :eid").setParameter("eid", (Object)eid).getResultList();
        if (lst.size() == 0) {
            return;
        }
        Station s = (Station)lst.get(0);
        Station rs = this.stationManagerService.findStationByEId(eid);
        if (rs != null) {
            Station ars = this.stationManagerService.findStationByEId(eid);
            try {
                BeanUtils.copyProperties((Object)rs, (Object)s);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.copyId(rs, ars);
            this.stationManagerService.updateStation(rs);
        } else {
            rs = new Station();
            try {
                BeanUtils.copyProperties((Object)rs, (Object)s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.resetId(rs);
            this.stationManagerService.addStation(rs);
        }
    }

    public void downloadStation(String eid) {
        this.checkStationManagerService();
    }

    private void resetId(Station dst) {
        dst.setId(0L);
        dst.getBlockette050().setId(0L);
        if (dst.getBlockette050().getNetworkInfo() != null) {
            dst.getBlockette050().setNetworkInfo(this.stationManagerService.findNetworkInfoById(dst.getBlockette050().getNetworkInfo().getId()));
        }
        dst.getStationInfo().setId(0L);
        dst.getStationCorr().setId(0L);
        dst.getStationSite().setId(0L);
        int size = dst.getBlockette051().size();
        int i = 0;
        while (i < size) {
            dst.getBlockette051().get(i).setId(0L);
            ++i;
        }
        List<Channel> chns_dst = dst.getChannel();
        size = chns_dst.size();
        int i2 = 0;
        while (i2 < size) {
            String unit;
            Channel chn_dst = chns_dst.get(i2);
            chn_dst.setId(0L);
            chn_dst.setStation(dst);
            chn_dst.getBlockette052().setId(0L);
            if (chn_dst.getBlockette052().getInstrument() != null) {
                chn_dst.getBlockette052().getInstrument().setId(0L);
            }
            if (chn_dst.getBlockette052().getDataFormat() != null) {
                chn_dst.getBlockette052().getDataFormat().setId(0L);
            }
            if (chn_dst.getBlockette052().getUnitOfCalibrationInput() != null) {
                unit = chn_dst.getBlockette052().getUnitOfCalibrationInput().getUnitName();
                chn_dst.getBlockette052().setUnitOfCalibrationInput(this.stationManagerService.findBlockette034ByName(unit));
            }
            if (chn_dst.getBlockette052().getUnitOfSignalResponse() != null) {
                unit = chn_dst.getBlockette052().getUnitOfSignalResponse().getUnitName();
                chn_dst.getBlockette052().setUnitOfSignalResponse(this.stationManagerService.findBlockette034ByName(unit));
            }
            List<Response> rsps_dst = chn_dst.getResponse();
            int rsp_size = rsps_dst.size();
            int j = 0;
            while (j < rsp_size) {
                String ounit;
                String iunit;
                Response rsp_dst = rsps_dst.get(j);
                rsp_dst.setId(0L);
                rsp_dst.setChannel(chn_dst);
                if (rsp_dst.getBlockette053() != null) {
                    rsp_dst.getBlockette053().setId(0L);
                    if (rsp_dst.getBlockette053().getPoleBlob() != null) {
                        rsp_dst.getBlockette053().getPoleBlob().setId(0L);
                    }
                    if (rsp_dst.getBlockette053().getZeroBlob() != null) {
                        rsp_dst.getBlockette053().getZeroBlob().setId(0L);
                    }
                    iunit = rsp_dst.getBlockette053().getSignalInputUnit().getUnitName();
                    rsp_dst.getBlockette053().setSignalInputUnit(this.stationManagerService.findBlockette034ByName(iunit));
                    ounit = rsp_dst.getBlockette053().getSignalOutputUnit().getUnitName();
                    rsp_dst.getBlockette053().setSignalOutputUnit(this.stationManagerService.findBlockette034ByName(ounit));
                }
                if (rsp_dst.getBlockette054() != null) {
                    rsp_dst.getBlockette054().setId(0L);
                    if (rsp_dst.getBlockette054().getNumBlob() != null) {
                        rsp_dst.getBlockette054().getNumBlob().setId(0L);
                    }
                    if (rsp_dst.getBlockette054().getDenBlob() != null) {
                        rsp_dst.getBlockette054().getDenBlob().setId(0L);
                    }
                    iunit = rsp_dst.getBlockette054().getSignalInputUnit().getUnitName();
                    rsp_dst.getBlockette054().setSignalInputUnit(this.stationManagerService.findBlockette034ByName(iunit));
                    ounit = rsp_dst.getBlockette054().getSignalOutputUnit().getUnitName();
                    rsp_dst.getBlockette054().setSignalOutputUnit(this.stationManagerService.findBlockette034ByName(ounit));
                }
                if (rsp_dst.getBlockette057() != null) {
                    rsp_dst.getBlockette057().setId(0L);
                }
                if (rsp_dst.getBlockette058() != null) {
                    rsp_dst.getBlockette058().setId(0L);
                }
                if (rsp_dst.getBlockette061() != null) {
                    rsp_dst.getBlockette061().setId(0L);
                    if (rsp_dst.getBlockette061().getFirCoeffBlob() != null) {
                        rsp_dst.getBlockette061().getFirCoeffBlob().setId(0L);
                    }
                    iunit = rsp_dst.getBlockette061().getSignalInputUnit().getUnitName();
                    rsp_dst.getBlockette061().setSignalInputUnit(this.stationManagerService.findBlockette034ByName(iunit));
                    ounit = rsp_dst.getBlockette061().getSignalOutputUnit().getUnitName();
                    rsp_dst.getBlockette061().setSignalOutputUnit(this.stationManagerService.findBlockette034ByName(ounit));
                }
                ++j;
            }
            ++i2;
        }
    }

    private void copyId(Station src, Station dst) {
        dst.setId(src.getId());
        dst.setExchangeId(src.getExchangeId());
        dst.getBlockette050().setId(src.getBlockette050().getId());
        if (src.getBlockette050().getNetworkInfo() != null) {
            dst.getBlockette050().setNetworkInfo(this.stationManagerService.findNetworkInfoById(src.getBlockette050().getNetworkInfo().getId()));
        }
        dst.getStationInfo().setId(src.getStationInfo().getId());
        dst.getStationCorr().setId(src.getStationCorr().getId());
        dst.getStationSite().setId(src.getStationSite().getId());
        int size = dst.getBlockette051().size();
        int i = 0;
        while (i < size) {
            dst.getBlockette051().get(i).setId(src.getBlockette051().get(i).getId());
            ++i;
        }
        List<Channel> chns_dst = dst.getChannel();
        List<Channel> chns_src = src.getChannel();
        size = chns_dst.size();
        int i2 = 0;
        while (i2 < size) {
            Channel chn_dst = chns_dst.get(i2);
            Channel chn_src = chns_src.get(i2);
            chn_dst.setId(chn_src.getId());
            chn_dst.setStation(dst);
            chn_dst.getBlockette052().setId(chn_src.getBlockette052().getId());
            List<Response> rsps_dst = chn_dst.getResponse();
            List<Response> rsps_src = chn_src.getResponse();
            int rsp_size = rsps_dst.size();
            int j = 0;
            while (j < rsp_size) {
                Response rsp_dst = rsps_dst.get(j);
                Response rsp_src = rsps_src.get(j);
                rsp_dst.setId(rsp_src.getId());
                rsp_dst.setChannel(chn_dst);
                if (rsp_dst.getBlockette053() != null) {
                    rsp_dst.getBlockette053().setId(rsp_src.getBlockette053().getId());
                }
                if (rsp_dst.getBlockette054() != null) {
                    rsp_dst.getBlockette054().setId(rsp_src.getBlockette054().getId());
                }
                if (rsp_dst.getBlockette057() != null) {
                    rsp_dst.getBlockette057().setId(rsp_src.getBlockette057().getId());
                }
                if (rsp_dst.getBlockette058() != null) {
                    rsp_dst.getBlockette058().setId(rsp_src.getBlockette058().getId());
                }
                if (rsp_dst.getBlockette061() != null) {
                    rsp_dst.getBlockette061().setId(rsp_src.getBlockette061().getId());
                }
                ++j;
            }
            ++i2;
        }
    }
}

