/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.WaveformCon;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Station;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.SessionContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.jboss.annotation.ejb.ResourceAdapter;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="activemq/topic/waveform"), @ActivationConfigProperty(propertyName="maxSessions", propertyValue="1"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue=""), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable")})
@ResourceAdapter(value="activemq-ra.rar")
public class WaveformActiveMQBean
implements MessageListener {
    static Logger logger = Logger.getLogger(WaveformActiveMQBean.class);
    @Resource
    private SessionContext ctx;
    @PersistenceContext
    private EntityManager manager;
    @Resource(name="WaveformBean/maxWaveformStoreTime", type=Integer.class)
    private int maxWaveformStoreTime = 720;
    private byte[] buffer = new byte[512];
    private List<WaveformCon> waveformList = new LinkedList<WaveformCon>();
    private HashMap<String, Channel> maps = null;
    private long ct = System.currentTimeMillis();

    public void onMessage(Message recvMsg) {
        if (this.maps == null) {
            this.initMaps();
        }
        if (recvMsg instanceof BytesMessage) {
            BytesMessage byteMsg = (BytesMessage)recvMsg;
            try {
                int nbyte = (int)byteMsg.getBodyLength();
                if (nbyte > this.buffer.length) {
                    logger.warn("Got message length > " + this.buffer.length);
                }
                byteMsg.readBytes(this.buffer, nbyte);
                this.waveformList.add(new WaveformCon(GenericMiniSeedRecord.buildMiniSeedRecord(this.buffer)));
                if (this.waveformList.size() >= 1000 || System.currentTimeMillis() - this.ct > 10000L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("size= " + this.waveformList.size() + ", time=" + (System.currentTimeMillis() - this.ct));
                    }
                    for (WaveformCon w : this.waveformList) {
                        w.setChannel(this.maps.get(w.getChannelLocator().toString()));
                        this.manager.persist(w);
                    }
                    this.manager.flush();
                    this.manager.clear();
                    this.waveformList.clear();
                    this.ct = System.currentTimeMillis();
                }
            }
            catch (JMSException jmsEx) {
                logger.warn(jmsEx.getMessage(), jmsEx);
            }
        }
    }

    private void initMaps() {
        this.maps = new HashMap(512);
        Dataless dataless = this.manager.find(Dataless.class, 1L);
        if (dataless != null) {
            logger.info("get dataless");
            for (Station sta : dataless.getSeedConfig().getStation()) {
                for (Channel chn : sta.getChannel()) {
                    String cl = String.valueOf(sta.getBlockette050().getNetworkCode()) + "/" + sta.getBlockette050().getStation();
                    cl = String.valueOf(cl) + "/" + chn.getBlockette052().getLocation() + "/" + chn.getBlockette052().getChannel();
                    this.maps.put(cl, chn);
                }
            }
        }
        logger.info("inited Maps.");
    }

    @PostConstruct
    public void postConstruct() {
        logger.info("Receiving waveform stream.");
    }
}

