/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.test;

import java.util.Date;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class TestActiveMQJBoss {
    static Logger logger = Logger.getLogger(TestActiveMQJBoss.class);
    private JmsTemplate jmsTemplate;
    private Topic topic;
    private int messageSize = 800;
    private Connection connection = null;
    private MessageProducer producer = null;
    private Session session = null;

    private String createMessageText(int index) {
        StringBuffer buffer = new StringBuffer(this.messageSize);
        buffer.append("Message: " + index + " sent at: " + new Date());
        if (buffer.length() > this.messageSize) {
            return buffer.substring(0, this.messageSize);
        }
        int i = buffer.length();
        while (i < this.messageSize) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public void send0(int index) {
        if (this.connection == null) {
            try {
                this.connection = this.jmsTemplate.getConnectionFactory().createConnection();
                this.connection.start();
                this.session = this.connection.createSession(false, 1);
                this.producer = this.session.createProducer(this.topic);
                this.producer.setDeliveryMode(2);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        try {
            TextMessage message = this.session.createTextMessage(this.createMessageText(index));
            this.producer.send(message);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void send(final int index) {
        this.jmsTemplate.send(this.topic, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage tm = session.createTextMessage(TestActiveMQJBoss.this.createMessageText(index));
                return tm;
            }
        });
    }

    public static void main(String[] args) throws Exception {
        FileSystemResource res = new FileSystemResource("JOPENS-service-test.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        TestActiveMQJBoss test = (TestActiveMQJBoss)factory.getBean("testActiveMQJBoss");
        long ct = System.currentTimeMillis();
        int count = 10000;
        int i = 0;
        while (i < count) {
            test.send(i);
            ++i;
        }
        System.out.println((long)count / ((System.currentTimeMillis() - ct) / 1000L));
        if (test.session != null) {
            test.session.close();
        }
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }
}

