/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.test;

import cn.org.gddsn.jopens.entity.CaliInfo;
import cn.org.gddsn.jopens.entity.CaliParam;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.util.EntityXmlUtils;
import cn.org.gddsn.jopens.entity.util.ResponseXML;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class TestSeedVolumeService {
    static Logger logger = Logger.getLogger(TestSeedVolumeService.class);
    private SeedVolumeService seedVolumeService;

    public void writeSeedVolumeDataless() throws IOException {
        Dataless dataless = this.readSeedVolumeDataless();
        long ct = System.currentTimeMillis();
        try {
            this.seedVolumeService.writeDataless(dataless);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        System.out.println("insert time:" + (System.currentTimeMillis() - ct) / 1000L);
    }

    public void testdeleteRtsEventInfo() {
        this.seedVolumeService.deleteRtsEventInfo(48);
    }

    public void testwriteReplication() {
        NetworkInfo ni = this.seedVolumeService.findNetworkInfoSelf();
        ni.setDirector("ME");
        this.seedVolumeService.writeReplication(ni);
    }

    public void testFindDataless() {
        this.seedVolumeService.findDefaultDataless();
    }

    public void testDeleteEventInfo() {
        this.seedVolumeService.deleteEventInfo("1", true);
    }

    public void testReadCaliInfo() {
        CaliInfo ci = this.seedVolumeService.findCaliInfo(44L);
        CaliInfo dest = new CaliInfo();
        try {
            BeanUtils.copyProperties((Object)dest, (Object)ci);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        dest.setId(88L);
        this.seedVolumeService.writeCaliInfo(dest);
    }

    public void testWriteUniEventId() {
        UniEventId uniEventId = new UniEventId();
        uniEventId.setSaveTime(null);
        uniEventId.setNationEventId("hwh");
        this.seedVolumeService.writeUniEventId(uniEventId);
    }

    public void testWriteCaliInfo() {
        CaliInfo ci = new CaliInfo();
        ci.setNetCode("GX");
        ci.setStaCode("XXX");
        ci.setLocId("00");
        ci.setCaliType("Pulse");
        ci.setStartTime(new Date());
        ci.setEndTime(new Date());
        this.seedVolumeService.writeCaliInfo(ci);
    }

    public void testWriteCaliParam() {
        CaliParam ci = new CaliParam();
        ci.setNetCode("GD");
        ci.setStaCode("XXX");
        ci.setLocId("00");
        this.seedVolumeService.writeCaliParam(ci);
    }

    public Dataless readSeedVolumeDataless() throws IOException {
        Dataless dataless = new Dataless();
        FileInputStream in = new FileInputStream("/home/hwh/tmp/seed/hwh.seed");
        dataless.readSeedVolumeDataless(new PushbackInputStream(in, 4096));
        in.close();
        return dataless;
    }

    public void testWriteResponseXML() throws Exception {
        Dataless dl = this.seedVolumeService.findDefaultDataless();
        Station s = dl.getSeedConfig().getStation().get(0);
        Channel c = s.getChannel().get(0);
        ResponseXML rxml = new ResponseXML();
        rxml.setNetCode(s.getBlockette050().getNetworkCode());
        rxml.setStationCode(s.getBlockette050().getStation());
        rxml.setLocId(c.getBlockette052().getLocation());
        rxml.setChanCode(c.getBlockette052().getChannel());
        rxml.setRsp(c.getResponse());
        FileOutputStream os = new FileOutputStream("/tmp/rsp.xml");
        EntityXmlUtils.write(os, rxml, ResponseXML.class);
        ((OutputStream)os).close();
    }

    public void testDataless() throws Exception {
        int n = 1000;
        int i = 0;
        while (i < n) {
            long now = System.currentTimeMillis();
            Dataless dl = this.seedVolumeService.findDefaultDataless();
            this.seedVolumeService.findClear();
            logger.info(String.valueOf(dl.getId()) + ": " + (System.currentTimeMillis() - now));
            ++i;
        }
    }

    public void testMagType() {
        MagType mt = this.seedVolumeService.findMagTypeById("Mb");
        if (mt == null) {
            logger.info("mb shoul not be null");
        }
        if ((mt = this.seedVolumeService.findMagTypeById("Mw")) == null) {
            logger.info("Mw shoul not be null");
        }
        if ((mt = this.seedVolumeService.findMagTypeById("Mwp")) == null) {
            logger.info("Mwp shoul not be null");
        }
        if ((mt = this.seedVolumeService.findMagTypeById("Ms")) == null) {
            logger.info("Ms shoul not be null");
        }
        if ((mt = this.seedVolumeService.findMagTypeById("mBB")) == null) {
            logger.info("mBB shoul not be null");
        }
    }

    public void testUpdateRtsEventInfo() {
        String eventId = "IA.200805251115.0007";
        Date start = new Date();
        Date end = new Date(start.getTime() + 3600000L);
        this.seedVolumeService.updateRtsEventInfo(eventId, start, end);
    }

    public static void main(String[] args) throws Exception {
        FileSystemResource res = new FileSystemResource("JOPENS-service-test.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        SeedVolumeService service = (SeedVolumeService)factory.getBean("seedVolumeService");
        TestSeedVolumeService test = new TestSeedVolumeService();
        test.setSeedVolumeService(service);
        long ct = System.currentTimeMillis();
        test.testMagType();
        System.out.println("access time: " + (System.currentTimeMillis() - ct));
    }

    public SeedVolumeService getSeedVolumeService() {
        return this.seedVolumeService;
    }

    public void setSeedVolumeService(SeedVolumeService seedVolumeService) {
        this.seedVolumeService = seedVolumeService;
    }
}

